/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class XtextWebDocument
implements IXtextWebDocument {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final List<Issue> issues = CollectionLiterals.newArrayList((Object[])new Issue[0]);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private String resourceId;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextResource resource;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private String text;
    @Accessors
    private boolean dirty;
    @Accessors
    private boolean processingCompleted;
    @Inject
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    private DocumentSynchronizer synchronizer;

    public String setInput(XtextResource resource, String resourceId) {
        String _xblockexpression = null;
        this.resource = resource;
        this.resourceId = resourceId;
        _xblockexpression = this.refresh();
        return _xblockexpression;
    }

    protected String refresh() {
        String _xblockexpression = null;
        this.issues.clear();
        String _elvis = null;
        IParseResult _parseResult = this.resource.getParseResult();
        ICompositeNode _rootNode = null;
        if (_parseResult != null) {
            _rootNode = _parseResult.getRootNode();
        }
        String _text = null;
        if (_rootNode != null) {
            _text = _rootNode.getText();
        }
        _elvis = _text != null ? _text : "";
        _xblockexpression = this.text = _elvis;
        return _xblockexpression;
    }

    @Override
    public String getStateId() {
        long _modificationStamp = this.resource.getModificationStamp();
        return Long.toString(_modificationStamp, 16);
    }

    @Override
    public void setText(String text) {
        try {
            this.resource.reparse(text);
            this.refresh();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void updateText(String text, int offset, int replaceLength) {
        this.resource.update(offset, replaceLength, text);
        this.refresh();
    }

    @Override
    public void createNewStateId() {
        long _modificationStamp = this.resource.getModificationStamp();
        long newStateId = _modificationStamp + 1L;
        this.resource.setModificationStamp(newStateId);
    }

    @Pure
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    @Pure
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    @Pure
    public XtextResource getResource() {
        return this.resource;
    }

    @Override
    @Pure
    public String getText() {
        return this.text;
    }

    @Override
    @Pure
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    @Pure
    public boolean isProcessingCompleted() {
        return this.processingCompleted;
    }

    @Override
    public void setProcessingCompleted(boolean processingCompleted) {
        this.processingCompleted = processingCompleted;
    }

    @Pure
    DocumentSynchronizer getSynchronizer() {
        return this.synchronizer;
    }
}

