/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.web.server.contentassist.ContentAssistResult;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.CurrentTypeFinder;

public class WebContentProposalProvider {
    private static final Logger LOG = Logger.getLogger(WebContentProposalProvider.class);
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IScopeProvider scopeProvider;
    @Inject
    @Extension
    private CurrentTypeFinder _currentTypeFinder;

    public void createProposals(ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        ImmutableList _firstSetGrammarElements = context.getFirstSetGrammarElements();
        for (AbstractElement element : _firstSetGrammarElements) {
            this.createProposals(element, context, acceptor);
        }
    }

    protected void _createProposals(AbstractElement element, ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        if (_terminal instanceof CrossReference) {
            AbstractElement _terminal_1 = assignment.getTerminal();
            this.createProposals(_terminal_1, context, acceptor);
        }
    }

    protected void _createProposals(final Keyword keyword, ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        String _prefix;
        String value = keyword.getValue();
        boolean _startsWith = value.startsWith(_prefix = context.getPrefix());
        if (_startsWith) {
            String _prefix_1 = context.getPrefix();
            ContentAssistResult.Entry _entry = new ContentAssistResult.Entry("keyword", _prefix_1);
            Procedures.Procedure1<ContentAssistResult.Entry> _function = new Procedures.Procedure1<ContentAssistResult.Entry>(){

                public void apply(ContentAssistResult.Entry it) {
                    String _value = keyword.getValue();
                    it.setProposal(_value);
                }
            };
            ContentAssistResult.Entry _doubleArrow = (ContentAssistResult.Entry)ObjectExtensions.operator_doubleArrow((Object)_entry, (Procedures.Procedure1)_function);
            acceptor.accept((Object)_doubleArrow);
        }
    }

    protected void _createProposals(final RuleCall ruleCall, final ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        boolean _and = false;
        AbstractRule _rule = ruleCall.getRule();
        if (!(_rule instanceof TerminalRule)) {
            _and = false;
        } else {
            boolean _isEmpty;
            String _prefix = context.getPrefix();
            _and = _isEmpty = _prefix.isEmpty();
        }
        if (_and) {
            String _prefix_1 = context.getPrefix();
            ContentAssistResult.Entry _entry = new ContentAssistResult.Entry("terminal", _prefix_1);
            Procedures.Procedure1<ContentAssistResult.Entry> _function = new Procedures.Procedure1<ContentAssistResult.Entry>(){

                public void apply(ContentAssistResult.Entry it) {
                    AbstractRule _rule = ruleCall.getRule();
                    String _name = _rule.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)"STRING");
                    if (_equals) {
                        EObject container = ruleCall.eContainer();
                        if (container instanceof Assignment) {
                            String _feature = ((Assignment)container).getFeature();
                            String _plus = "\"" + _feature;
                            String _plus_1 = _plus + "\"";
                            it.setProposal(_plus_1);
                            AbstractRule _rule_1 = ruleCall.getRule();
                            String _name_1 = _rule_1.getName();
                            it.setDescription(_name_1);
                        } else {
                            AbstractRule _rule_2 = ruleCall.getRule();
                            String _name_2 = _rule_2.getName();
                            String _plus_2 = "\"" + _name_2;
                            String _plus_3 = _plus_2 + "\"";
                            it.setProposal(_plus_3);
                        }
                        ArrayList<ContentAssistResult.EditPosition> _editPositions = it.getEditPositions();
                        int _offset = context.getOffset();
                        int _plus_4 = _offset + 1;
                        String _proposal = it.getProposal();
                        int _length = _proposal.length();
                        int _minus = _length - 2;
                        ContentAssistResult.EditPosition _editPosition = new ContentAssistResult.EditPosition(_plus_4, _minus);
                        _editPositions.add(_editPosition);
                    } else {
                        EObject container_1 = ruleCall.eContainer();
                        if (container_1 instanceof Assignment) {
                            String _feature_1 = ((Assignment)container_1).getFeature();
                            it.setProposal(_feature_1);
                            AbstractRule _rule_3 = ruleCall.getRule();
                            String _name_3 = _rule_3.getName();
                            it.setDescription(_name_3);
                        } else {
                            AbstractRule _rule_4 = ruleCall.getRule();
                            String _name_4 = _rule_4.getName();
                            it.setProposal(_name_4);
                        }
                        ArrayList<ContentAssistResult.EditPosition> _editPositions_1 = it.getEditPositions();
                        int _offset_1 = context.getOffset();
                        String _proposal_1 = it.getProposal();
                        int _length_1 = _proposal_1.length();
                        ContentAssistResult.EditPosition _editPosition_1 = new ContentAssistResult.EditPosition(_offset_1, _length_1);
                        _editPositions_1.add(_editPosition_1);
                    }
                }
            };
            ContentAssistResult.Entry _doubleArrow = (ContentAssistResult.Entry)ObjectExtensions.operator_doubleArrow((Object)_entry, (Procedures.Procedure1)_function);
            acceptor.accept((Object)_doubleArrow);
        }
    }

    protected void _createProposals(CrossReference reference, ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        EReference ereference;
        EClassifier type = this._currentTypeFinder.findCurrentTypeAfter((AbstractElement)reference);
        if (type instanceof EClass && (ereference = GrammarUtil.getReference((CrossReference)reference, (EClass)((EClass)type))) != null) {
            EObject _currentModel = context.getCurrentModel();
            IScope scope = this.scopeProvider.getScope(_currentModel, ereference);
            try {
                Iterable _allElements = scope.getAllElements();
                for (final IEObjectDescription description : _allElements) {
                    String _prefix;
                    QualifiedName _name = description.getName();
                    final String elementName = _name.toString();
                    boolean _startsWith = elementName.startsWith(_prefix = context.getPrefix());
                    if (!_startsWith) continue;
                    String _prefix_1 = context.getPrefix();
                    ContentAssistResult.Entry _entry = new ContentAssistResult.Entry("cross-ref", _prefix_1);
                    Procedures.Procedure1<ContentAssistResult.Entry> _function = new Procedures.Procedure1<ContentAssistResult.Entry>(){

                        public void apply(ContentAssistResult.Entry it) {
                            it.setProposal(elementName);
                            EClass _eClass = description.getEClass();
                            String _name = _eClass.getName();
                            it.setDescription(_name);
                        }
                    };
                    ContentAssistResult.Entry _doubleArrow = (ContentAssistResult.Entry)ObjectExtensions.operator_doubleArrow((Object)_entry, (Procedures.Procedure1)_function);
                    acceptor.accept((Object)_doubleArrow);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException uoe = (UnsupportedOperationException)_t;
                    LOG.error((Object)"Failed to create content assist proposals for cross-reference.", (Throwable)uoe);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected void createProposals(AbstractElement assignment, ContentAssistContext context, IAcceptor<ContentAssistResult.Entry> acceptor) {
        if (assignment instanceof Assignment) {
            this._createProposals((Assignment)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof CrossReference) {
            this._createProposals((CrossReference)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof Keyword) {
            this._createProposals((Keyword)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof RuleCall) {
            this._createProposals((RuleCall)assignment, context, acceptor);
            return;
        }
        if (assignment != null) {
            this._createProposals(assignment, context, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(assignment, context, acceptor).toString());
    }

    @Pure
    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }
}

