/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistResult;
import org.eclipse.xtext.web.server.contentassist.WebContentProposalProvider;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ContentAssistService {
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private WebContentProposalProvider proposalProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    @Extension
    private UpdateDocumentService _updateDocumentService;

    public ContentAssistResult createProposals(XtextWebDocumentAccess document, final ITextRegion selection, final int offset) throws InvalidRequestException {
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        Procedures.Procedure1<ContentAssistContextFactory> _function = new Procedures.Procedure1<ContentAssistContextFactory>(){

            public void apply(ContentAssistContextFactory it) {
                it.setPool(ContentAssistService.this.executorService);
            }
        };
        final ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function_1 = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _stateId;
                ContentAssistContext[] _xblockexpression = null;
                stateIdWrapper[0] = _stateId = it.getStateId();
                String _text = it.getText();
                XtextResource _resource = it.getResource();
                _xblockexpression = contextFactory.create(_text, selection, offset, _resource);
                return _xblockexpression;
            }
        };
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function_2 = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                ContentAssistService.this._updateDocumentService.processUpdatedDocument(it, cancelIndicator);
                return null;
            }
        };
        ContentAssistContext[] contexts = document.priorityReadOnly(_function_1, _function_2);
        String _get_1 = stateIdWrapper[0];
        return this.createProposals(contexts, _get_1);
    }

    public ContentAssistResult createProposalsWithUpdate(XtextWebDocumentAccess document, final String deltaText, final int deltaOffset, final int deltaReplaceLength, final ITextRegion textSelection, final int caretOffset) {
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        Procedures.Procedure1<ContentAssistContextFactory> _function = new Procedures.Procedure1<ContentAssistContextFactory>(){

            public void apply(ContentAssistContextFactory it) {
                it.setPool(ContentAssistService.this.executorService);
            }
        };
        final ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function_1 = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _stateId;
                ContentAssistContext[] _xblockexpression = null;
                it.setDirty(true);
                it.setProcessingCompleted(false);
                it.createNewStateId();
                stateIdWrapper[0] = _stateId = it.getStateId();
                it.updateText(deltaText, deltaOffset, deltaReplaceLength);
                String _text = it.getText();
                XtextResource _resource = it.getResource();
                _xblockexpression = contextFactory.create(_text, textSelection, caretOffset, _resource);
                return _xblockexpression;
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_2 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                ContentAssistService.this._updateDocumentService.processUpdatedDocument(it, cancelIndicator);
                return null;
            }
        };
        ContentAssistContext[] contexts = document.modify(_function_1, _function_2);
        String _get_1 = stateIdWrapper[0];
        return this.createProposals(contexts, _get_1);
    }

    protected ContentAssistResult createProposals(ContentAssistContext[] contexts, String stateId) {
        boolean _not;
        ContentAssistResult result = new ContentAssistResult();
        result.setStateId(stateId);
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)contexts)).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            IAcceptor<ContentAssistResult.Entry> _function;
            final HashSet<ContentAssistResult.Entry> proposals = new HashSet<ContentAssistResult.Entry>();
            IAcceptor<ContentAssistResult.Entry> acceptor = _function = new IAcceptor<ContentAssistResult.Entry>(){

                public void accept(ContentAssistResult.Entry it) {
                    proposals.add(it);
                }
            };
            Functions.Function1<ContentAssistContext, String> _function_1 = new Functions.Function1<ContentAssistContext, String>(){

                public String apply(ContentAssistContext it) {
                    return it.getPrefix();
                }
            };
            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)contexts)), (Functions.Function1)_function_1);
            Functions.Function1<String, Integer> _function_2 = new Functions.Function1<String, Integer>(){

                public Integer apply(String it) {
                    return it.length();
                }
            };
            String longestPrefix = (String)IterableExtensions.maxBy((Iterable)_map, (Functions.Function1)_function_2);
            for (ContentAssistContext context : contexts) {
                String _prefix = context.getPrefix();
                boolean _equals = Objects.equal((Object)_prefix, (Object)longestPrefix);
                if (!_equals) continue;
                this.proposalProvider.createProposals(context, acceptor);
            }
            ArrayList<ContentAssistResult.Entry> _entries = result.getEntries();
            Iterable<ContentAssistResult.Entry> _filter = this.filter(proposals);
            Iterables.addAll(_entries, _filter);
            ArrayList<ContentAssistResult.Entry> _entries_1 = result.getEntries();
            this.sort(_entries_1);
        }
        return result;
    }

    protected Iterable<ContentAssistResult.Entry> filter(final Collection<ContentAssistResult.Entry> proposals) {
        Functions.Function1<ContentAssistResult.Entry, Boolean> _function = new Functions.Function1<ContentAssistResult.Entry, Boolean>(){

            public Boolean apply(ContentAssistResult.Entry it) {
                String _prefix;
                String _proposal_1;
                boolean _startsWith;
                boolean _not;
                boolean _xblockexpression = false;
                boolean _or = false;
                String _proposal = it.getProposal();
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_proposal);
                _or = _isNullOrEmpty ? true : (_not = !(_startsWith = (_proposal_1 = it.getProposal()).startsWith(_prefix = it.getPrefix())));
                if (_or) {
                    return false;
                }
                boolean _switchResult = false;
                String _type = it.getType();
                boolean _matched = false;
                if (!_matched && Objects.equal((Object)_type, (Object)"keyword")) {
                    boolean _equals;
                    _matched = true;
                    boolean _or_1 = false;
                    int _size = proposals.size();
                    boolean bl = _equals = _size == 1;
                    if (_equals) {
                        _or_1 = true;
                    } else {
                        boolean _isLetter;
                        String _proposal_2 = it.getProposal();
                        char _charAt = _proposal_2.charAt(0);
                        _or_1 = _isLetter = Character.isLetter(_charAt);
                    }
                    _switchResult = _or_1;
                }
                if (!_matched) {
                    _switchResult = true;
                }
                _xblockexpression = _switchResult;
                return _xblockexpression;
            }
        };
        return IterableExtensions.filter(proposals, (Functions.Function1)_function);
    }

    protected void sort(List<ContentAssistResult.Entry> proposals) {
        Comparator<ContentAssistResult.Entry> _function = new Comparator<ContentAssistResult.Entry>(){

            @Override
            public int compare(ContentAssistResult.Entry a, ContentAssistResult.Entry b) {
                String _type_1;
                int _xifexpression = 0;
                String _type = a.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)(_type_1 = b.getType()));
                if (_equals) {
                    String _proposal = a.getProposal();
                    String _proposal_1 = b.getProposal();
                    _xifexpression = _proposal.compareTo(_proposal_1);
                } else {
                    String _type_2 = a.getType();
                    String _type_3 = b.getType();
                    _xifexpression = _type_2.compareTo(_type_3);
                }
                return _xifexpression;
            }
        };
        Collections.sort(proposals, _function);
    }
}

