/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.ISessionStore;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.ServiceConflictResult;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourceContentResult;
import org.eclipse.xtext.web.server.persistence.ResourcePersistenceService;
import org.eclipse.xtext.web.server.validation.ValidationService;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class XtextServiceDispatcher {
    private static final Logger LOG = Logger.getLogger(XtextServiceDispatcher.class);
    @Inject
    private ResourcePersistenceService resourcePersistenceService;
    @Inject
    private UpdateDocumentService updateDocumentService;
    @Inject
    private ContentAssistService contentAssistService;
    @Inject
    private ValidationService validationService;
    @Inject
    private IServerResourceHandler resourceHandler;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private Provider<XtextWebDocument> documentProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public ServiceDescriptor getService(String path, Map<String, String> parameters, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final String requestType = this.getRequestType(path, parameters);
        boolean _isTraceEnabled = LOG.isTraceEnabled();
        if (_isTraceEnabled) {
            Set<Map.Entry<String, String>> _entrySet = parameters.entrySet();
            Functions.Function1<Map.Entry<String, String>, String> _function = new Functions.Function1<Map.Entry<String, String>, String>(){

                public String apply(Map.Entry<String, String> it) {
                    return it.getKey();
                }
            };
            List _sortBy = IterableExtensions.sortBy(_entrySet, (Functions.Function1)_function);
            Functions.Function1<Map.Entry<String, String>, CharSequence> _function_1 = new Functions.Function1<Map.Entry<String, String>, CharSequence>(){

                public CharSequence apply(Map.Entry<String, String> it) {
                    boolean _greaterThan;
                    String _xifexpression = null;
                    String _value = it.getValue();
                    int _length = _value.length();
                    boolean bl = _greaterThan = _length > 18;
                    if (_greaterThan) {
                        String _key = it.getKey();
                        String _plus = _key + "='";
                        String _value_1 = it.getValue();
                        String _substring = _value_1.substring(0, 16);
                        String _plus_1 = _plus + _substring;
                        _xifexpression = _plus_1 + "...'";
                    } else {
                        String _xifexpression_1 = null;
                        String _value_2 = it.getValue();
                        boolean _matches = _value_2.matches(".*\\s+.*");
                        if (_matches) {
                            String _key_1 = it.getKey();
                            String _plus_2 = _key_1 + "='";
                            String _value_3 = it.getValue();
                            String _plus_3 = _plus_2 + _value_3;
                            _xifexpression_1 = _plus_3 + "'";
                        } else {
                            String _key_2 = it.getKey();
                            String _plus_4 = _key_2 + "=";
                            String _value_4 = it.getValue();
                            _xifexpression_1 = _plus_4 + _value_4;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    return _xifexpression;
                }
            };
            String _join = IterableExtensions.join((Iterable)_sortBy, (CharSequence)": ", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function_1);
            String stringParams = _join.replaceAll("(\\n|\\f|\\r)+", " ");
            LOG.trace((Object)("xtext-service/" + requestType + stringParams));
        }
        ServiceDescriptor _xtrycatchfinallyexpression = null;
        try {
            ServiceDescriptor _switchResult = null;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)requestType, (Object)"load")) {
                _matched = true;
                _switchResult = this.getLoadResourceService(false, parameters, sessionStore);
            }
            if (!_matched && Objects.equal((Object)requestType, (Object)"revert")) {
                _matched = true;
                _switchResult = this.getLoadResourceService(true, parameters, sessionStore);
            }
            if (!_matched && Objects.equal((Object)requestType, (Object)"save")) {
                _matched = true;
                _switchResult = this.getSaveResourceService(parameters, sessionStore);
            }
            if (!_matched && Objects.equal((Object)requestType, (Object)"update")) {
                _matched = true;
                _switchResult = this.getUpdateDocumentService(parameters, sessionStore);
            }
            if (!_matched && Objects.equal((Object)requestType, (Object)"validation")) {
                _matched = true;
                _switchResult = this.getValidationService(parameters, sessionStore);
            }
            if (!_matched && Objects.equal((Object)requestType, (Object)"content-assist")) {
                _matched = true;
                _switchResult = this.getContentAssistService(parameters, sessionStore);
            }
            if (!_matched) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The request type '" + requestType + "' is not supported.");
            }
            Procedures.Procedure1<ServiceDescriptor> _function_2 = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(ServiceDescriptor it) {
                    it.type = requestType;
                }
            };
            _xtrycatchfinallyexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_switchResult, (Procedures.Procedure1)_function_2);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException) {
                InvalidRequestException ire = (InvalidRequestException)_t;
                InvalidRequestException.Type _type = ire.getType();
                boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)InvalidRequestException.Type.INVALID_DOCUMENT_STATE));
                if (_equals) {
                    LOG.trace((Object)("Invalid document state (" + requestType + ")"));
                    ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
                    Procedures.Procedure1<ServiceDescriptor> _function_3 = new Procedures.Procedure1<ServiceDescriptor>(){

                        public void apply(ServiceDescriptor it) {
                            it.type = requestType;
                            Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                                public IServiceResult apply() {
                                    return new ServiceConflictResult("invalidStateId");
                                }
                            };
                            it.service = (Functions.Function0)_function;
                            it.hasConflict = true;
                        }
                    };
                    return (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function_3);
                }
                throw ire;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected String getRequestType(String contextPath, Map<String, String> parameters) {
        StringTokenizer tokenizer;
        boolean _hasMoreTokens;
        if (contextPath != null && (_hasMoreTokens = (tokenizer = new StringTokenizer(contextPath, "/")).hasMoreTokens())) {
            return tokenizer.nextToken();
        }
        String _elvis = null;
        String _get = parameters.get("requestType");
        _elvis = _get != null ? _get : "";
        return _elvis;
    }

    protected ServiceDescriptor getLoadResourceService(final boolean revert, Map<String, String> parameters, final ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final String resourceId = parameters.get("resource");
        if (resourceId == null) {
            throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'resource' is required.");
        }
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            ResourceContentResult _xifexpression = null;
                            _xifexpression = revert ? XtextServiceDispatcher.this.resourcePersistenceService.revert(resourceId, XtextServiceDispatcher.this.resourceHandler, sessionStore) : XtextServiceDispatcher.this.resourcePersistenceService.load(resourceId, XtextServiceDispatcher.this.resourceHandler, sessionStore);
                            _xtrycatchfinallyexpression = _xifexpression;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                it.hasSideEffects = revert;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getSaveResourceService(final Map<String, String> parameters, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(parameters, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.resourcePersistenceService.save(document, XtextServiceDispatcher.this.resourceHandler);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                it.hasSideEffects = true;
                boolean _containsKey = parameters.containsKey("fullText");
                it.hasTextInput = _containsKey;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getUpdateDocumentService(Map<String, String> parameters, final ISessionStore sessionStore) throws InvalidRequestException {
        final String resourceId = parameters.get("resource");
        if (resourceId == null) {
            throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'resource' is required.");
        }
        final String fullText = parameters.get("fullText");
        final boolean[] initializedFromFullText = new boolean[1];
        Provider<XtextWebDocument> _function = new Provider<XtextWebDocument>(){

            public XtextWebDocument get() {
                try {
                    XtextWebDocument _xifexpression = null;
                    if (fullText == null) {
                        throw new InvalidRequestException(InvalidRequestException.Type.RESOURCE_NOT_FOUND, "The requested resource was not found.");
                    }
                    XtextWebDocument _xblockexpression = null;
                    initializedFromFullText[0] = true;
                    _xifexpression = _xblockexpression = XtextServiceDispatcher.this.getFullTextDocument(fullText, resourceId, sessionStore);
                    return _xifexpression;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        XtextWebDocument _resourceDocument = this.getResourceDocument(resourceId, sessionStore, _function);
        String _get = parameters.get("requiredStateId");
        final XtextWebDocumentAccess document = new XtextWebDocumentAccess(_resourceDocument, _get);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function_1 = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(ServiceDescriptor it) {
                it.hasSideEffects = true;
                it.hasTextInput = true;
            }
        };
        final ServiceDescriptor result = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function_1);
        if (fullText == null) {
            final String deltaText = parameters.get("deltaText");
            if (deltaText == null) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "One of the parameters 'deltaText' and 'fullText' must be specified.");
            }
            Optional _absent = Optional.absent();
            final int deltaOffset = this.getInt(parameters, "deltaOffset", (Optional<Integer>)_absent);
            if (deltaOffset < 0) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'deltaOffset' must not be negative.");
            }
            Optional _absent_1 = Optional.absent();
            final int deltaReplaceLength = this.getInt(parameters, "deltaReplaceLength", (Optional<Integer>)_absent_1);
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'deltaReplaceLength' must not be negative.");
            }
            Functions.Function0<IServiceResult> _function_2 = new Functions.Function0<IServiceResult>(){

                public IServiceResult apply() {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = XtextServiceDispatcher.this.updateDocumentService.updateDeltaText(document, deltaText, deltaOffset, deltaReplaceLength);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(result, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                }
            };
            result.service = (Functions.Function0)_function_2;
        } else {
            boolean _containsKey = parameters.containsKey("deltaText");
            if (_containsKey) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            Functions.Function0<IServiceResult> _function_3 = new Functions.Function0<IServiceResult>(){

                public IServiceResult apply() {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        boolean _get = initializedFromFullText[0];
                        boolean _not = !_get;
                        _xtrycatchfinallyexpression = XtextServiceDispatcher.this.updateDocumentService.updateFullText(document, fullText, _not);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(result, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                }
            };
            result.service = (Functions.Function0)_function_3;
        }
        return result;
    }

    protected ServiceDescriptor getContentAssistService(final Map<String, String> parameters, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        Optional _of = Optional.of((Object)0);
        final int offset = this.getInt(parameters, "caretOffset", (Optional<Integer>)_of);
        final XtextWebDocumentAccess document = this.getDocumentAccess(parameters, sessionStore);
        Optional _of_1 = Optional.of((Object)offset);
        int selectionStart = this.getInt(parameters, "selectionStart", (Optional<Integer>)_of_1);
        Optional _of_2 = Optional.of((Object)selectionStart);
        int selectionEnd = this.getInt(parameters, "selectionEnd", (Optional<Integer>)_of_2);
        int _max = Math.max(selectionEnd - selectionStart, 0);
        final TextRegion selection = new TextRegion(selectionStart, _max);
        final String deltaText = parameters.get("deltaText");
        ServiceDescriptor _xifexpression = null;
        if (deltaText == null) {
            ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
            Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(final ServiceDescriptor it) {
                    Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                        public IServiceResult apply() {
                            IServiceResult _xtrycatchfinallyexpression = null;
                            try {
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.contentAssistService.createProposals(document, (ITextRegion)selection, offset);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Throwable) {
                                    Throwable throwable = _t;
                                    _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            return _xtrycatchfinallyexpression;
                        }
                    };
                    it.service = (Functions.Function0)_function;
                    boolean _containsKey = parameters.containsKey("fullText");
                    it.hasTextInput = _containsKey;
                }
            };
            _xifexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        } else {
            ServiceDescriptor _xblockexpression_1 = null;
            boolean _containsKey = parameters.containsKey("fullText");
            if (_containsKey) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            Optional _absent = Optional.absent();
            final int deltaOffset = this.getInt(parameters, "deltaOffset", (Optional<Integer>)_absent);
            if (deltaOffset < 0) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'deltaOffset' must not be negative.");
            }
            Optional _absent_1 = Optional.absent();
            final int deltaReplaceLength = this.getInt(parameters, "deltaReplaceLength", (Optional<Integer>)_absent_1);
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter 'deltaReplaceLength' must not be negative.");
            }
            ServiceDescriptor _serviceDescriptor_1 = new ServiceDescriptor();
            Procedures.Procedure1<ServiceDescriptor> _function_1 = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(final ServiceDescriptor it) {
                    Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                        public IServiceResult apply() {
                            IServiceResult _xtrycatchfinallyexpression = null;
                            try {
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.contentAssistService.createProposalsWithUpdate(document, deltaText, deltaOffset, deltaReplaceLength, (ITextRegion)selection, offset);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Throwable) {
                                    Throwable throwable = _t;
                                    _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            return _xtrycatchfinallyexpression;
                        }
                    };
                    it.service = (Functions.Function0)_function;
                    it.hasSideEffects = true;
                    it.hasTextInput = true;
                }
            };
            _xifexpression = _xblockexpression_1 = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor_1, (Procedures.Procedure1)_function_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ServiceDescriptor getValidationService(final Map<String, String> parameters, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(parameters, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.validationService.validate(document);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                boolean _containsKey = parameters.containsKey("fullText");
                it.hasTextInput = _containsKey;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected XtextWebDocumentAccess getDocumentAccess(Map<String, String> parameters, ISessionStore sessionStore) throws InvalidRequestException {
        XtextWebDocument document = null;
        boolean _containsKey = parameters.containsKey("fullText");
        if (_containsKey) {
            XtextWebDocument _fullTextDocument;
            String _get = parameters.get("fullText");
            document = _fullTextDocument = this.getFullTextDocument(_get, null, sessionStore);
        } else {
            boolean _containsKey_1 = parameters.containsKey("resource");
            if (_containsKey_1) {
                XtextWebDocument _resourceDocument;
                String _get_1 = parameters.get("resource");
                Provider<XtextWebDocument> _function = new Provider<XtextWebDocument>(){

                    public XtextWebDocument get() {
                        try {
                            throw new InvalidRequestException(InvalidRequestException.Type.RESOURCE_NOT_FOUND, "The requested resource was not found.");
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                document = _resourceDocument = this.getResourceDocument(_get_1, sessionStore, _function);
            } else {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "At least one of the parameters 'resource' and 'fullText' must be specified.");
            }
        }
        String _get_2 = parameters.get("requiredStateId");
        return new XtextWebDocumentAccess(document, _get_2);
    }

    protected XtextWebDocument getFullTextDocument(String fullText, String resourceId, ISessionStore sessionStore) {
        try {
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            String _elvis = null;
            if (resourceId != null) {
                _elvis = resourceId;
            } else {
                String _plus;
                String _primaryFileExtension = this.fileExtensionProvider.getPrimaryFileExtension();
                _elvis = _plus = "fullText." + _primaryFileExtension;
            }
            URI uri = URI.createURI((String)_elvis);
            Resource _createResource = this.resourceFactory.createResource(uri);
            XtextResource resource = (XtextResource)_createResource;
            EList _resources = resourceSet.getResources();
            _resources.add((Object)resource);
            StringInputStream _stringInputStream = new StringInputStream(fullText);
            resource.load((InputStream)_stringInputStream, null);
            XtextWebDocument document = (XtextWebDocument)this.documentProvider.get();
            document.setInput(resource, resourceId);
            if (resourceId != null) {
                Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
                sessionStore.put(_mappedTo, document);
            }
            return document;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected XtextWebDocument getResourceDocument(final String resourceId, ISessionStore sessionStore, final Provider<XtextWebDocument> alternativeDocumentProvider) {
        Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
        Functions.Function0<XtextWebDocument> _function = new Functions.Function0<XtextWebDocument>(){

            public XtextWebDocument apply() {
                try {
                    return XtextServiceDispatcher.this.resourceHandler.get(resourceId);
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException ioe = (IOException)_t;
                        return (XtextWebDocument)alternativeDocumentProvider.get();
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        return sessionStore.get(_mappedTo, _function);
    }

    protected int getInt(Map<String, String> parameters, String key, Optional<Integer> defaultValue) throws InvalidRequestException {
        String stringValue = parameters.get(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter '" + key + "' must be specified.");
            }
            Integer _get = (Integer)defaultValue.get();
            return _get;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException nfe = (NumberFormatException)_t;
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter '" + key + "' must contain an integer value.");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean getBoolean(Map<String, String> parameters, String key, Optional<Boolean> defaultValue) throws InvalidRequestException {
        String stringValue = parameters.get(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter '" + key + "' must be specified.");
            }
            Boolean _get = (Boolean)defaultValue.get();
            return _get;
        }
        String _lowerCase = stringValue.toLowerCase();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_lowerCase, (Object)"true")) {
            _matched = true;
            return true;
        }
        if (!_matched && Objects.equal((Object)_lowerCase, (Object)"false")) {
            _matched = true;
            return false;
        }
        throw new InvalidRequestException(InvalidRequestException.Type.INVALID_PARAMETERS, "The parameter '" + key + "' must contain a Boolean value.");
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, Throwable throwable) {
        try {
            boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(throwable);
            if (_isOperationCanceledException) {
                LOG.trace((Object)("Service canceled (" + service.type + ")"));
                return new ServiceConflictResult("canceled");
            }
            throw throwable;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, InvalidRequestException exception) {
        try {
            InvalidRequestException.Type _type = exception.getType();
            boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)InvalidRequestException.Type.INVALID_DOCUMENT_STATE));
            if (_equals) {
                LOG.trace((Object)("Invalid document state (" + service.type + ")"));
                return new ServiceConflictResult("invalidStateId");
            }
            throw exception;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ServiceConflictResult handleError(ServiceDescriptor service, Throwable exception) {
        if (exception instanceof InvalidRequestException) {
            return this._handleError(service, (InvalidRequestException)exception);
        }
        if (exception != null) {
            return this._handleError(service, exception);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(service, exception).toString());
    }

    @Accessors
    @ToString
    public static class ServiceDescriptor {
        private String type;
        private Functions.Function0<? extends IServiceResult> service;
        private boolean hasSideEffects;
        private boolean hasTextInput;
        private boolean hasConflict;

        @Pure
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Pure
        public Functions.Function0<? extends IServiceResult> getService() {
            return this.service;
        }

        public void setService(Functions.Function0<? extends IServiceResult> service) {
            this.service = service;
        }

        @Pure
        public boolean isHasSideEffects() {
            return this.hasSideEffects;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        @Pure
        public boolean isHasTextInput() {
            return this.hasTextInput;
        }

        public void setHasTextInput(boolean hasTextInput) {
            this.hasTextInput = hasTextInput;
        }

        @Pure
        public boolean isHasConflict() {
            return this.hasConflict;
        }

        public void setHasConflict(boolean hasConflict) {
            this.hasConflict = hasConflict;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("type", (Object)this.type);
            b.add("service", this.service);
            b.add("hasSideEffects", (Object)this.hasSideEffects);
            b.add("hasTextInput", (Object)this.hasTextInput);
            b.add("hasConflict", (Object)this.hasConflict);
            return b.toString();
        }
    }
}

