/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.persistence;

import com.google.inject.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.persistence.IResourceBaseProvider;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FileResourceHandler
implements IServerResourceHandler {
    @Inject
    private IResourceBaseProvider resourceBaseProvider;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private Provider<XtextWebDocument> documentProvider;
    @Inject
    private IEncodingProvider encodingProvider;

    @Override
    public XtextWebDocument get(final String resourceId) throws IOException {
        try {
            URI uri = this.resourceBaseProvider.getFileURI(resourceId);
            if (uri == null) {
                throw new IOException("The requested resource does not exist.");
            }
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            Resource _resource = resourceSet.getResource(uri, true);
            final XtextResource resource = (XtextResource)_resource;
            XtextWebDocument _get = (XtextWebDocument)this.documentProvider.get();
            Procedures.Procedure1<XtextWebDocument> _function = new Procedures.Procedure1<XtextWebDocument>(){

                public void apply(XtextWebDocument it) {
                    it.setInput(resource, resourceId);
                }
            };
            return (XtextWebDocument)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof WrappedException) {
                    WrappedException exception = (WrappedException)_t;
                    throw exception.getCause();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @Override
    public void put(IXtextWebDocument document) throws IOException {
        try {
            try {
                String _resourceId = document.getResourceId();
                URI uri = this.resourceBaseProvider.getFileURI(_resourceId);
                XtextResource _resource = document.getResource();
                ResourceSet _resourceSet = _resource.getResourceSet();
                URIConverter _uRIConverter = _resourceSet.getURIConverter();
                OutputStream outputStream = _uRIConverter.createOutputStream(uri);
                String _encoding = this.encodingProvider.getEncoding(uri);
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, _encoding);
                String _text = document.getText();
                writer.write(_text);
                writer.close();
            }
            catch (Throwable _t) {
                if (_t instanceof WrappedException) {
                    WrappedException exception = (WrappedException)_t;
                    throw exception.getCause();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

