/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;

@Singleton
public class UpdateDocumentService {
    @Inject
    private IResourceValidator resourceValidator;

    public DocumentStateResult updateFullText(XtextWebDocumentAccess document, final String fullText, final boolean reparse) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                if (reparse) {
                    it.setDirty(true);
                    it.setProcessingCompleted(false);
                    it.createNewStateId();
                }
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                if (reparse) {
                    it.setText(fullText);
                }
                UpdateDocumentService.this.processUpdatedDocument(it, cancelIndicator);
                return null;
            }
        };
        return document.modify(_function, _function_1);
    }

    public DocumentStateResult updateDeltaText(XtextWebDocumentAccess document, final String deltaText, final int offset, final int replaceLength) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.setDirty(true);
                it.setProcessingCompleted(false);
                it.createNewStateId();
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.updateText(deltaText, offset, replaceLength);
                UpdateDocumentService.this.processUpdatedDocument(it, cancelIndicator);
                return null;
            }
        };
        return document.modify(_function, _function_1);
    }

    public void processUpdatedDocument(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        boolean _not;
        boolean _isProcessingCompleted = it.isProcessingCompleted();
        boolean bl = _not = !_isProcessingCompleted;
        if (_not) {
            Collection<Issue> _issues = it.getIssues();
            XtextResource _resource = it.getResource();
            List _validate = this.resourceValidator.validate((Resource)_resource, CheckMode.ALL, cancelIndicator);
            _issues.addAll(_validate);
            it.setProcessingCompleted(true);
        }
    }
}

