/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

class DocumentSynchronizer
implements CancelIndicator {
    private final Semaphore semaphore = new Semaphore(1, true);
    private final AtomicInteger waitingPriorityJobs = new AtomicInteger();
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private OperationCanceledManager operationCanceledManager;
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private ExecutorService executorService;
    @Accessors
    private boolean canceled;

    DocumentSynchronizer() {
    }

    public Boolean acquireLock(boolean priority) {
        try {
            boolean _xblockexpression = false;
            if (priority) {
                this.waitingPriorityJobs.incrementAndGet();
                this.canceled = true;
            }
            this.semaphore.acquire();
            boolean _xifexpression = false;
            if (priority) {
                boolean _equals;
                boolean _xifexpression_1 = false;
                int _decrementAndGet = this.waitingPriorityJobs.decrementAndGet();
                boolean bl = _equals = _decrementAndGet == 0;
                if (_equals) {
                    this.canceled = false;
                    _xifexpression_1 = false;
                }
                _xifexpression = _xifexpression_1;
            } else {
                this.operationCanceledManager.checkCanceled((CancelIndicator)this);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void releaseLock() {
        boolean _notEquals;
        int _availablePermits = this.semaphore.availablePermits();
        boolean bl = _notEquals = _availablePermits != 0;
        if (_notEquals) {
            throw new IllegalStateException("Cannot release a lock without acquiring it first.");
        }
        this.semaphore.release();
    }

    @Pure
    public OperationCanceledManager getOperationCanceledManager() {
        return this.operationCanceledManager;
    }

    @Pure
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Pure
    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

