/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.occurrences;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.occurrences.OccurrencesResult;
import org.eclipse.xtext.web.server.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.web.server.util.ElementAtOffsetUtil;

@Singleton
public class OccurrencesService {
    @Inject
    private ElementAtOffsetUtil elementAtOffsetUtil;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    private IReferenceFinder referenceFinder;

    public OccurrencesResult findOccurrences(XtextWebDocumentAccess document, final int offset) {
        return document.readOnly(new CancelableUnitOfWork<OccurrencesResult, IXtextWebDocument>(){

            public OccurrencesResult exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                EObject element = OccurrencesService.this.elementAtOffsetUtil.getElementAt(doc.getResource(), offset);
                final OccurrencesResult occurrencesResult = new OccurrencesResult(doc.getStateId());
                if (element != null && OccurrencesService.this.filter(element)) {
                    ITextRegion definitionRegion;
                    URI elementURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)element);
                    TargetURIs targetURIs = (TargetURIs)OccurrencesService.this.targetURIsProvider.get();
                    targetURIs.addURI(elementURI);
                    IReferenceFinder.Acceptor acceptor = new IReferenceFinder.Acceptor(){

                        public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                            ITextRegion region = OccurrencesService.this.locationInFileProvider.getSignificantTextRegion(source, (EStructuralFeature)eReference, index);
                            occurrencesResult.getReadRegions().add(new TextRegion(region.getOffset(), region.getLength()));
                        }

                        public void accept(IReferenceDescription description) {
                        }
                    };
                    OccurrencesService.this.referenceFinder.findReferences((Predicate)targetURIs, (Resource)doc.getResource(), acceptor, (IProgressMonitor)new CancelIndicatorProgressMonitor(cancelIndicator));
                    if (Objects.equals(element.eResource(), doc.getResource()) && (definitionRegion = OccurrencesService.this.locationInFileProvider.getSignificantTextRegion(element)) != null && definitionRegion != ITextRegionWithLineInformation.EMPTY_REGION) {
                        occurrencesResult.getWriteRegions().add(new TextRegion(definitionRegion.getOffset(), definitionRegion.getLength()));
                    }
                }
                return occurrencesResult;
            }
        });
    }

    protected boolean filter(EObject element) {
        return element.eContainer() != null;
    }
}

