/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ContentAssistService {
    public static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    private IdeContentProposalProvider proposalProvider;

    public ContentAssistResult createProposals(XtextWebDocumentAccess document, final ITextRegion selection, final int caretOffset, int proposalsLimit) throws InvalidRequestException {
        final String[] stateIdWrapper = new String[1];
        ContentAssistContext[] contexts = document.priorityReadOnly(new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                stateIdWrapper[0] = it.getStateId();
                return ContentAssistService.this.getContexts(it, selection, caretOffset);
            }
        });
        List<ContentAssistContext> contextsList = Arrays.asList(contexts);
        return this.createProposals(contextsList, stateIdWrapper[0], proposalsLimit);
    }

    public ContentAssistResult createProposalsWithUpdate(XtextWebDocumentAccess document, final String deltaText, final int deltaOffset, final int deltaReplaceLength, final ITextRegion selection, final int caretOffset, int proposalsLimit) throws InvalidRequestException {
        final String[] stateIdWrapper = new String[1];
        ContentAssistContext[] contexts = document.modify(new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.setDirty(true);
                it.createNewStateId();
                stateIdWrapper[0] = it.getStateId();
                it.updateText(deltaText, deltaOffset, deltaReplaceLength);
                return ContentAssistService.this.getContexts(it, selection, caretOffset);
            }
        });
        List<ContentAssistContext> contextsList = Arrays.asList(contexts);
        return this.createProposals(contextsList, stateIdWrapper[0], proposalsLimit);
    }

    public ContentAssistContext[] getContexts(IXtextWebDocument document, ITextRegion selection, int caretOffset) {
        if (caretOffset > document.getText().length()) {
            return new ContentAssistContext[0];
        }
        ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        contextFactory.setPool(this.executorService);
        return contextFactory.create(document.getText(), selection, caretOffset, document.getResource());
    }

    protected ContentAssistResult createProposals(List<ContentAssistContext> contexts, String stateId, final int proposalsLimit) {
        ContentAssistResult result = new ContentAssistResult(stateId);
        if (!contexts.isEmpty()) {
            final HashSet proposals = new HashSet();
            IIdeContentProposalAcceptor acceptor = new IIdeContentProposalAcceptor(){

                public void accept(ContentAssistEntry entry, int priority) {
                    if (entry != null) {
                        if (entry.getProposal() == null) {
                            throw new IllegalArgumentException("proposal must not be null.");
                        }
                        proposals.add(Pair.of((Object)priority, (Object)entry));
                    }
                }

                public boolean canAcceptMoreProposals() {
                    return proposals.size() < proposalsLimit;
                }
            };
            this.proposalProvider.createProposals(contexts, acceptor);
            List sorted = IterableExtensions.sortWith(proposals, (p1, p2) -> {
                String s2;
                int prioResult = ((Integer)p2.getKey()).compareTo((Integer)p1.getKey());
                if (prioResult != 0) {
                    return prioResult;
                }
                String s1 = ((ContentAssistEntry)p1.getValue()).getLabel();
                if (s1 == null) {
                    s1 = ((ContentAssistEntry)p1.getValue()).getProposal();
                }
                if ((s2 = ((ContentAssistEntry)p2.getValue()).getLabel()) == null) {
                    s2 = ((ContentAssistEntry)p2.getValue()).getProposal();
                }
                return s1.compareTo(s2);
            });
            result.getEntries().addAll(Lists.transform((List)sorted, it -> (ContentAssistEntry)it.getValue()));
        }
        return result;
    }

    public IdeContentProposalProvider getProposalProvider() {
        return this.proposalProvider;
    }
}

