/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.generator.GeneratorResult;
import org.eclipse.xtext.web.server.generator.IContentTypeProvider;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class GeneratorService
extends AbstractCachedService<GeneratedArtifacts> {
    public static final String DEFAULT_ARTIFACT = "DEFAULT_OUTPUT/DEFAULT_ARTIFACT";
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private IContentTypeProvider contentTypeProvider;
    @Inject
    private Provider<InMemoryFileSystemAccess> fileSystemAccessProvider;

    @Override
    public GeneratedArtifacts compute(IXtextWebDocument doc, CancelIndicator cancelIndicator) {
        InMemoryFileSystemAccess fileSystemAccess = (InMemoryFileSystemAccess)this.fileSystemAccessProvider.get();
        this.generator.generate((Resource)doc.getResource(), (IFileSystemAccess2)fileSystemAccess, () -> cancelIndicator);
        GeneratedArtifacts result = new GeneratedArtifacts();
        for (Map.Entry e : fileSystemAccess.getTextFiles().entrySet()) {
            String contentType = this.contentTypeProvider.getContentType((String)e.getKey());
            result.artifacts.add(new GeneratorResult((String)e.getKey(), contentType, ((CharSequence)e.getValue()).toString()));
        }
        return result;
    }

    public GeneratorResult getArtifact(XtextWebDocumentAccess document, String artifactId) {
        List<GeneratorResult> artifacts = ((GeneratedArtifacts)this.getResult((XtextWebDocumentAccess)document)).artifacts;
        String searchString = artifactId != null ? artifactId : DEFAULT_ARTIFACT;
        for (GeneratorResult r : artifacts) {
            if (!searchString.equals(r.getName())) continue;
            return r;
        }
        if (!searchString.startsWith("DEFAULT_OUTPUT")) {
            String defaultSearchString = "DEFAULT_OUTPUT" + searchString;
            for (GeneratorResult r : artifacts) {
                if (!defaultSearchString.equals(r.getName())) continue;
                return r;
            }
        }
        throw new InvalidRequestException.ResourceNotFoundException("The requested generator artifact was not found.");
    }

    public GeneratorResult getArtifact(XtextWebDocumentAccess document, String artifactId, boolean includeContent) {
        GeneratorResult result = this.getArtifact(document, artifactId);
        if (includeContent) {
            return result;
        }
        return new GeneratorResult(result.getName(), result.getContentType(), null);
    }

    public GeneratedArtifacts getResult(XtextWebDocumentAccess document, boolean includeContent) {
        if (includeContent) {
            return (GeneratedArtifacts)this.getResult(document);
        }
        List<GeneratorResult> artifacts = ((GeneratedArtifacts)this.getResult((XtextWebDocumentAccess)document)).artifacts;
        GeneratedArtifacts result = new GeneratedArtifacts();
        for (GeneratorResult r : artifacts) {
            result.artifacts.add(new GeneratorResult(r.getName(), r.getContentType(), null));
        }
        return result;
    }

    public static class GeneratedArtifacts
    implements IServiceResult {
        private final List<GeneratorResult> artifacts = new ArrayList<GeneratorResult>();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifacts == null ? 0 : this.artifacts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedArtifacts other = (GeneratedArtifacts)obj;
            return !(this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("artifacts", this.artifacts);
            return b.toString();
        }

        public List<GeneratorResult> getArtifacts() {
            return this.artifacts;
        }
    }
}

