/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.persistence;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.model.IWebDocumentProvider;
import org.eclipse.xtext.web.server.model.IWebResourceSetProvider;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.persistence.IResourceBaseProvider;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class FileResourceHandler
implements IServerResourceHandler {
    @Inject
    private IResourceBaseProvider resourceBaseProvider;
    @Inject
    private IWebResourceSetProvider resourceSetProvider;
    @Inject
    private IWebDocumentProvider documentProvider;
    @Inject
    private IEncodingProvider encodingProvider;

    @Override
    public XtextWebDocument get(String resourceId, IServiceContext serviceContext) throws IOException {
        try {
            URI uri = this.resourceBaseProvider.getFileURI(resourceId);
            if (uri == null) {
                throw new IOException("The requested resource does not exist.");
            }
            ResourceSet resourceSet = this.resourceSetProvider.get(resourceId, serviceContext);
            XtextResource resource = (XtextResource)resourceSet.getResource(uri, true);
            XtextWebDocument document = this.documentProvider.get(resourceId, serviceContext);
            document.setInput(resource);
            return document;
        }
        catch (WrappedException exception) {
            throw Exceptions.sneakyThrow((Throwable)exception.getCause());
        }
    }

    @Override
    public void put(IXtextWebDocument document, IServiceContext serviceContext) throws IOException {
        try {
            URI uri = this.resourceBaseProvider.getFileURI(document.getResourceId());
            try (OutputStreamWriter writer = new OutputStreamWriter(document.getResource().getResourceSet().getURIConverter().createOutputStream(uri), this.encodingProvider.getEncoding(uri));){
                writer.write(document.getText());
            }
            catch (WrappedException exception) {
                throw exception.getCause();
            }
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

