/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.XtextWebDocument;

@ImplementedBy(value=DefaultImpl.class)
public interface IWebDocumentProvider {
    public XtextWebDocument get(String var1, IServiceContext var2);

    public static class DefaultImpl
    implements IWebDocumentProvider {
        @Inject
        private Provider<DocumentSynchronizer> synchronizerProvider;

        @Override
        public XtextWebDocument get(String resourceId, IServiceContext serviceContext) {
            if (resourceId == null) {
                return new XtextWebDocument(resourceId, (DocumentSynchronizer)this.synchronizerProvider.get());
            }
            return new XtextWebDocument(resourceId, (DocumentSynchronizer)serviceContext.getSession().get(DocumentSynchronizer.class, () -> (DocumentSynchronizer)this.synchronizerProvider.get()));
        }
    }
}

