/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Inject;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DocumentSynchronizer
implements CancelIndicator {
    private final Semaphore semaphore = new Semaphore(1, true);
    private final AtomicInteger waitingPriorityJobs = new AtomicInteger();
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Accessors
    private volatile boolean canceled;

    public Boolean acquireLock(boolean priority) {
        try {
            if (priority) {
                this.waitingPriorityJobs.incrementAndGet();
                this.canceled = true;
            }
            this.semaphore.acquire();
            if (priority) {
                if (this.waitingPriorityJobs.decrementAndGet() == 0) {
                    this.canceled = false;
                    return false;
                }
                return false;
            }
            this.operationCanceledManager.checkCanceled((CancelIndicator)this);
            return false;
        }
        catch (InterruptedException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public void releaseLock() {
        if (this.semaphore.availablePermits() != 0) {
            throw new IllegalStateException("Cannot release a lock without acquiring it first.");
        }
        this.semaphore.release();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

