/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@Log
@FinalFieldsConstructor
public class XtextWebDocument
implements IXtextWebDocument {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final String resourceId;
    @Accessors(value={AccessorType.PACKAGE_GETTER})
    private final DocumentSynchronizer synchronizer;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextResource resource;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private String text;
    @Accessors
    private boolean dirty;
    private final Map<Class<?>, IServiceResult> cachedServiceResults = CollectionLiterals.newHashMap();
    private static final Logger LOG = Logger.getLogger(XtextWebDocument.class);

    public void clearCachedServiceResults() {
        this.cachedServiceResults.clear();
    }

    public <T extends IServiceResult> T getCachedServiceResult(AbstractCachedService<T> service, CancelIndicator cancelIndicator, boolean logCacheMiss) {
        IServiceResult _elvis = null;
        IServiceResult _get = this.cachedServiceResults.get(service.getClass());
        if (_get != null) {
            _elvis = _get;
        } else {
            Object _xblockexpression = null;
            if (logCacheMiss) {
                String _simpleName = service.getClass().getSimpleName();
                String _plus = "Cache miss for " + _simpleName;
                LOG.trace((Object)_plus);
            }
            T result = service.compute(this, cancelIndicator);
            this.cachedServiceResults.put(service.getClass(), (IServiceResult)result);
            _xblockexpression = result;
            _elvis = _xblockexpression;
        }
        return (T)_elvis;
    }

    public String toString() {
        String _xblockexpression = null;
        if (this.resourceId != null) {
            String _simpleName = this.getClass().getSimpleName();
            String _plus = _simpleName + "(";
            String _plus_1 = _plus + this.resourceId;
            return _plus_1 + ")";
        }
        _xblockexpression = super.toString();
        return _xblockexpression;
    }

    public String setInput(XtextResource resource) {
        String _xblockexpression = null;
        this.clearCachedServiceResults();
        this.resource = resource;
        _xblockexpression = this.refreshText();
        return _xblockexpression;
    }

    protected String refreshText() {
        String _elvis = null;
        IParseResult _parseResult = this.resource.getParseResult();
        ICompositeNode _rootNode = null;
        if (_parseResult != null) {
            _rootNode = _parseResult.getRootNode();
        }
        String _text = null;
        if (_rootNode != null) {
            _text = _rootNode.getText();
        }
        _elvis = _text != null ? _text : "";
        this.text = _elvis;
        return this.text;
    }

    @Override
    public String getStateId() {
        return Long.toString(this.resource.getModificationStamp(), 16);
    }

    @Override
    public void setText(String text) {
        try {
            this.clearCachedServiceResults();
            this.resource.reparse(text);
            this.refreshText();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void updateText(String text, int offset, int replaceLength) {
        this.clearCachedServiceResults();
        this.resource.update(offset, replaceLength, text);
        this.refreshText();
    }

    @Override
    public void createNewStateId() {
        long _modificationStamp = this.resource.getModificationStamp();
        long newStateId = _modificationStamp + 1L;
        this.resource.setModificationStamp(newStateId);
    }

    public XtextWebDocument(String resourceId, DocumentSynchronizer synchronizer) {
        this.resourceId = resourceId;
        this.synchronizer = synchronizer;
    }

    @Override
    @Pure
    public String getResourceId() {
        return this.resourceId;
    }

    @Pure
    DocumentSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    @Pure
    public XtextResource getResource() {
        return this.resource;
    }

    @Override
    @Pure
    public String getText() {
        return this.text;
    }

    @Override
    @Pure
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

