/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.formatting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.formatting.FormattingResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@Singleton
public class FormattingService {
    @Inject(optional=true)
    private INodeModelFormatter formatter1;
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;

    public FormattingResult format(XtextWebDocumentAccess document, final ITextRegion selection, final ITypedPreferenceValues preferences) throws InvalidRequestException {
        FormattingResult _xblockexpression = null;
        final Wrapper textWrapper = new Wrapper();
        final Wrapper regionWrapper = new Wrapper();
        CancelableUnitOfWork<FormattingResult, IXtextWebDocument> _function = new CancelableUnitOfWork<FormattingResult, IXtextWebDocument>(){

            public FormattingResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                if (FormattingService.this.formatter2Provider != null) {
                    textWrapper.set((Object)FormattingService.this.format2(it.getResource(), selection, preferences));
                    if (selection != null) {
                        int _offset = selection.getOffset();
                        int _length = selection.getLength();
                        TextRegion _textRegion = new TextRegion(_offset, _length);
                        regionWrapper.set((Object)_textRegion);
                    }
                } else if (FormattingService.this.formatter1 != null) {
                    INodeModelFormatter.IFormattedRegion formattedRegion = FormattingService.this.format1(it.getResource(), selection);
                    textWrapper.set((Object)formattedRegion.getFormattedText());
                    int _offset_1 = formattedRegion.getOffset();
                    int _length_1 = formattedRegion.getLength();
                    TextRegion _textRegion_1 = new TextRegion(_offset_1, _length_1);
                    regionWrapper.set((Object)_textRegion_1);
                } else {
                    throw new IllegalStateException("No formatter is available in the language configuration.");
                }
                it.setDirty(true);
                it.createNewStateId();
                String _stateId = it.getStateId();
                String _get = (String)textWrapper.get();
                TextRegion _get_1 = (TextRegion)regionWrapper.get();
                return new FormattingResult(_stateId, _get, _get_1);
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                boolean _isEmpty = regionWrapper.isEmpty();
                if (_isEmpty) {
                    it.setText((String)textWrapper.get());
                } else {
                    it.updateText((String)textWrapper.get(), ((TextRegion)regionWrapper.get()).getOffset(), ((TextRegion)regionWrapper.get()).getLength());
                }
                return null;
            }
        };
        _xblockexpression = document.modify(_function, _function_1);
        return _xblockexpression;
    }

    protected INodeModelFormatter.IFormattedRegion format1(XtextResource resource, ITextRegion selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return null;
        }
        ICompositeNode rootNode = parseResult.getRootNode();
        ITextRegion region = selection;
        if (region == null) {
            int _offset = rootNode.getOffset();
            int _length = rootNode.getLength();
            TextRegion _textRegion = new TextRegion(_offset, _length);
            region = _textRegion;
        }
        return this.formatter1.format(rootNode, region.getOffset(), region.getLength());
    }

    protected String format2(XtextResource resource, ITextRegion selection, ITypedPreferenceValues preferences) {
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        if (selection != null) {
            request.setRegions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ITextRegion[]{selection})));
        }
        if (preferences != null) {
            request.setPreferences(preferences);
        }
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        if (selection != null) {
            ITextRegionRewriter _rewriter = regionAccess.getRewriter();
            int _offset = selection.getOffset();
            int _length = selection.getLength();
            TextSegment _textSegment = new TextSegment(regionAccess, _offset, _length);
            return _rewriter.renderToString((ITextSegment)_textSegment, (Iterable)replacements);
        }
        return regionAccess.getRewriter().renderToString((Iterable)replacements);
    }
}

