/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.xtext.web.server.model;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Result object containing the current document state identifier.
 */
@Data
@SuppressWarnings("all")
public class DocumentStateResult implements IServiceResult {
  private final String stateId;
  
  public DocumentStateResult(final String stateId) {
    super();
    this.stateId = stateId;
  }
  
  @Override
  @Pure
  public int hashCode() {
    return 31 * 1 + ((this.stateId== null) ? 0 : this.stateId.hashCode());
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DocumentStateResult other = (DocumentStateResult) obj;
    if (this.stateId == null) {
      if (other.stateId != null)
        return false;
    } else if (!this.stateId.equals(other.stateId))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("stateId", this.stateId);
    return b.toString();
  }
  
  @Pure
  public String getStateId() {
    return this.stateId;
  }
}
