/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class ContentAssistService {
    public static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IdeContentProposalProvider proposalProvider;

    public ContentAssistResult createProposals(XtextWebDocumentAccess document, final ITextRegion selection, final int caretOffset, int proposalsLimit) throws InvalidRequestException {
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                ContentAssistContext[] _xblockexpression = null;
                stateIdWrapper[0] = it.getStateId();
                _xblockexpression = ContentAssistService.this.getContexts(it, selection, caretOffset);
                return _xblockexpression;
            }
        };
        ContentAssistContext[] contexts = document.priorityReadOnly(_function);
        return this.createProposals((List)Conversions.doWrapArray((Object)contexts), stateIdWrapper[0], proposalsLimit);
    }

    public ContentAssistResult createProposalsWithUpdate(XtextWebDocumentAccess document, final String deltaText, final int deltaOffset, final int deltaReplaceLength, final ITextRegion selection, final int caretOffset, int proposalsLimit) throws InvalidRequestException {
        final String[] stateIdWrapper = new String[1];
        CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument> _function = new CancelableUnitOfWork<ContentAssistContext[], IXtextWebDocument>(){

            public ContentAssistContext[] exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                ContentAssistContext[] _xblockexpression = null;
                it.setDirty(true);
                it.createNewStateId();
                stateIdWrapper[0] = it.getStateId();
                it.updateText(deltaText, deltaOffset, deltaReplaceLength);
                _xblockexpression = ContentAssistService.this.getContexts(it, selection, caretOffset);
                return _xblockexpression;
            }
        };
        ContentAssistContext[] contexts = document.modify(_function);
        return this.createProposals((List)Conversions.doWrapArray((Object)contexts), stateIdWrapper[0], proposalsLimit);
    }

    public ContentAssistContext[] getContexts(IXtextWebDocument document, ITextRegion selection, int caretOffset) {
        boolean _greaterThan;
        ContentAssistContext[] _xblockexpression = null;
        int _length = document.getText().length();
        boolean bl = _greaterThan = caretOffset > _length;
        if (_greaterThan) {
            return new ContentAssistContext[0];
        }
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        Procedures.Procedure1 _function = it -> it.setPool(this.executorService);
        ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        _xblockexpression = contextFactory.create(document.getText(), selection, caretOffset, document.getResource());
        return _xblockexpression;
    }

    protected ContentAssistResult createProposals(List<ContentAssistContext> contexts, String stateId, final int proposalsLimit) {
        boolean _not;
        ContentAssistResult result = new ContentAssistResult(stateId);
        boolean _isEmpty = contexts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            final HashSet proposals = new HashSet();
            IIdeContentProposalAcceptor acceptor = new IIdeContentProposalAcceptor(){

                public void accept(ContentAssistEntry entry, int priority) {
                    if (entry != null) {
                        boolean _tripleEquals;
                        String _proposal = entry.getProposal();
                        boolean bl = _tripleEquals = _proposal == null;
                        if (_tripleEquals) {
                            throw new IllegalArgumentException("proposal must not be null.");
                        }
                        Pair _mappedTo = Pair.of((Object)priority, (Object)entry);
                        proposals.add(_mappedTo);
                    }
                }

                public boolean canAcceptMoreProposals() {
                    int _size = proposals.size();
                    return _size < proposalsLimit;
                }
            };
            this.proposalProvider.createProposals(contexts, acceptor);
            Comparator _function = (p1, p2) -> {
                String _proposal_1;
                String _proposal;
                int prioResult = ((Integer)p2.getKey()).compareTo((Integer)p1.getKey());
                if (prioResult != 0) {
                    return prioResult;
                }
                String _elvis = null;
                String _label = ((ContentAssistEntry)p1.getValue()).getLabel();
                _elvis = _label != null ? _label : (_proposal = ((ContentAssistEntry)p1.getValue()).getProposal());
                String s1 = _elvis;
                String _elvis_1 = null;
                String _label_1 = ((ContentAssistEntry)p2.getValue()).getLabel();
                _elvis_1 = _label_1 != null ? _label_1 : (_proposal_1 = ((ContentAssistEntry)p2.getValue()).getProposal());
                String s2 = _elvis_1;
                return s1.compareTo(s2);
            };
            Functions.Function1 _function_1 = it -> (ContentAssistEntry)it.getValue();
            result.getEntries().addAll(ListExtensions.map((List)IterableExtensions.sortWith(proposals, (Comparator)_function), (Functions.Function1)_function_1));
        }
        return result;
    }

    @Pure
    public IdeContentProposalProvider getProposalProvider() {
        return this.proposalProvider;
    }
}

