/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.generator.GeneratorResult;
import org.eclipse.xtext.web.server.generator.IContentTypeProvider;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class GeneratorService
extends AbstractCachedService<GeneratedArtifacts> {
    public static final String DEFAULT_ARTIFACT = "DEFAULT_OUTPUT/DEFAULT_ARTIFACT";
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private IContentTypeProvider contentTypeProvider;
    @Inject
    private Provider<InMemoryFileSystemAccess> fileSystemAccessProvider;

    @Override
    public GeneratedArtifacts compute(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        InMemoryFileSystemAccess fileSystemAccess = (InMemoryFileSystemAccess)this.fileSystemAccessProvider.get();
        IGeneratorContext _function = () -> cancelIndicator;
        this.generator.generate((Resource)it.getResource(), (IFileSystemAccess2)fileSystemAccess, _function);
        GeneratedArtifacts result = new GeneratedArtifacts();
        Functions.Function1 _function_1 = it_1 -> {
            GeneratorResult _xblockexpression = null;
            String contentType = this.contentTypeProvider.getContentType((String)it_1.getKey());
            String _key = (String)it_1.getKey();
            String _string = ((CharSequence)it_1.getValue()).toString();
            _xblockexpression = new GeneratorResult(_key, contentType, _string);
            return _xblockexpression;
        };
        Iterables.addAll((Collection)result.artifacts, (Iterable)IterableExtensions.map(fileSystemAccess.getTextFiles().entrySet(), (Functions.Function1)_function_1));
        return result;
    }

    public GeneratorResult getArtifact(XtextWebDocumentAccess document, String artifactId) {
        List artifacts = ((GeneratedArtifacts)this.getResult(document)).artifacts;
        String _elvis = null;
        _elvis = artifactId != null ? artifactId : DEFAULT_ARTIFACT;
        String searchString = _elvis;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)searchString);
        };
        GeneratorResult result = (GeneratorResult)IterableExtensions.findFirst((Iterable)artifacts, (Functions.Function1)_function);
        if (result == null && !searchString.startsWith("DEFAULT_OUTPUT")) {
            String defaultSearchString = "DEFAULT_OUTPUT" + searchString;
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)defaultSearchString);
            };
            result = (GeneratorResult)IterableExtensions.findFirst((Iterable)artifacts, (Functions.Function1)_function_1);
        }
        if (result == null) {
            throw new InvalidRequestException.ResourceNotFoundException("The requested generator artifact was not found.");
        }
        return result;
    }

    public GeneratorResult getArtifact(XtextWebDocumentAccess document, String artifactId, boolean includeContent) {
        GeneratorResult result = this.getArtifact(document, artifactId);
        if (includeContent) {
            return result;
        }
        String _name = result.getName();
        String _contentType = result.getContentType();
        return new GeneratorResult(_name, _contentType, null);
    }

    public GeneratedArtifacts getResult(XtextWebDocumentAccess document, boolean includeContent) {
        if (includeContent) {
            return (GeneratedArtifacts)this.getResult(document);
        }
        List artifacts = ((GeneratedArtifacts)this.getResult(document)).artifacts;
        GeneratedArtifacts result = new GeneratedArtifacts();
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _contentType = it.getContentType();
            return new GeneratorResult(_name, _contentType, null);
        };
        result.artifacts.addAll(ListExtensions.map((List)artifacts, (Functions.Function1)_function));
        return result;
    }

    @Data
    public static class GeneratedArtifacts
    implements IServiceResult {
        private final List<GeneratorResult> artifacts = CollectionLiterals.newArrayList();

        @Pure
        public int hashCode() {
            return 31 + (this.artifacts == null ? 0 : this.artifacts.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedArtifacts other = (GeneratedArtifacts)obj;
            return !(this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("artifacts", this.artifacts);
            return b.toString();
        }

        @Pure
        public List<GeneratorResult> getArtifacts() {
            return this.artifacts;
        }
    }
}

