/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.ISession;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.ServiceConflictResult;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.formatting.FormattingService;
import org.eclipse.xtext.web.server.generator.GeneratorService;
import org.eclipse.xtext.web.server.hover.HoverResult;
import org.eclipse.xtext.web.server.hover.HoverService;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IWebDocumentProvider;
import org.eclipse.xtext.web.server.model.IWebResourceSetProvider;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.PrecomputedServiceRegistry;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.occurrences.OccurrencesService;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourceContentResult;
import org.eclipse.xtext.web.server.persistence.ResourcePersistenceService;
import org.eclipse.xtext.web.server.syntaxcoloring.HighlightingService;
import org.eclipse.xtext.web.server.validation.ValidationService;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
@Log
public class XtextServiceDispatcher {
    @Inject(optional=true)
    @FormatterPreferences
    private IPreferenceValuesProvider formatterPreferencesProvider;
    @Inject
    private ResourcePersistenceService resourcePersistenceService;
    @Inject
    private UpdateDocumentService updateDocumentService;
    @Inject
    private ContentAssistService contentAssistService;
    @Inject
    private ValidationService validationService;
    @Inject
    private HighlightingService highlightingService;
    @Inject
    private HoverService hoverService;
    @Inject
    private OccurrencesService occurrencesService;
    @Inject
    private FormattingService formattingService;
    @Inject
    private GeneratorService generatorService;
    @Inject
    private IServerResourceHandler resourceHandler;
    @Inject
    private IWebResourceSetProvider resourceSetProvider;
    @Inject
    private IWebDocumentProvider documentProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private XtextWebDocumentAccess.Factory documentAccessFactory;
    private final Random randomGenerator = new Random();
    private static final Logger LOG = Logger.getLogger(XtextServiceDispatcher.class);

    @Inject
    protected void registerPreComputedServices(PrecomputedServiceRegistry registry) {
        registry.addPrecomputedService(this.highlightingService);
        registry.addPrecomputedService(this.validationService);
    }

    public ServiceDescriptor getService(IServiceContext context) throws InvalidRequestException {
        String serviceType = context.getParameter("serviceType");
        if (serviceType == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'serviceType' is required.");
        }
        boolean _isTraceEnabled = LOG.isTraceEnabled();
        if (_isTraceEnabled) {
            Functions.Function1 _function = key -> {
                boolean _greaterThan;
                String _xblockexpression = null;
                String value = context.getParameter((String)key);
                String _xifexpression = null;
                int _length = value.length();
                boolean bl = _greaterThan = _length > 18;
                if (_greaterThan) {
                    String _substring = value.substring(0, 16);
                    String _plus = key + "='" + _substring;
                    _xifexpression = _plus + "...'";
                } else {
                    String _xifexpression_1 = null;
                    boolean _matches = value.matches(".*\\s+.*");
                    _xifexpression_1 = _matches ? key + "='" + value + "'" : key + "=" + value;
                    _xifexpression = _xifexpression_1;
                }
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            };
            String stringParams = IterableExtensions.join((Iterable)IterableExtensions.sort(context.getParameterKeys()), (CharSequence)": ", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function).replaceAll("(\\n|\\f|\\r)+", " ");
            LOG.trace((Object)("xtext-service/" + serviceType + stringParams));
        }
        try {
            ServiceDescriptor _createServiceDescriptor = this.createServiceDescriptor(serviceType, context);
            Procedures.Procedure1 _function_1 = it -> ((ServiceDescriptor)it).context = context;
            return (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_createServiceDescriptor, (Procedures.Procedure1)_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                InvalidRequestException.InvalidDocumentStateException ire = (InvalidRequestException.InvalidDocumentStateException)_t;
                LOG.trace((Object)("Invalid document state (" + serviceType + ")"));
                ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
                Procedures.Procedure1 _function_2 = it -> {
                    ((ServiceDescriptor)it).context = context;
                    Functions.Function0 _function_3 = () -> new ServiceConflictResult("invalidStateId");
                    ((ServiceDescriptor)it).service = _function_3;
                    ((ServiceDescriptor)it).hasConflict = true;
                };
                return (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ServiceDescriptor createServiceDescriptor(String serviceType, IServiceContext context) {
        ServiceDescriptor _switchResult = null;
        if (serviceType != null) {
            switch (serviceType) {
                case "load": {
                    _switchResult = this.getLoadResourceService(false, context);
                    break;
                }
                case "revert": {
                    _switchResult = this.getLoadResourceService(true, context);
                    break;
                }
                case "save": {
                    _switchResult = this.getSaveResourceService(context);
                    break;
                }
                case "update": {
                    _switchResult = this.getUpdateDocumentService(context);
                    break;
                }
                case "assist": {
                    _switchResult = this.getContentAssistService(context);
                    break;
                }
                case "validate": {
                    _switchResult = this.getValidationService(context);
                    break;
                }
                case "hover": {
                    _switchResult = this.getHoverService(context);
                    break;
                }
                case "highlight": {
                    _switchResult = this.getHighlightingService(context);
                    break;
                }
                case "occurrences": {
                    _switchResult = this.getOccurrencesService(context);
                    break;
                }
                case "format": {
                    _switchResult = this.getFormattingService(context);
                    break;
                }
                case "generate": {
                    _switchResult = this.getGeneratorService(context);
                    break;
                }
                default: {
                    throw new InvalidRequestException.InvalidParametersException("The service type '" + serviceType + "' is not supported.");
                }
            }
        } else {
            throw new InvalidRequestException.InvalidParametersException("The service type '" + serviceType + "' is not supported.");
        }
        return _switchResult;
    }

    protected ServiceDescriptor getLoadResourceService(boolean revert, IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        String resourceId = this.getResourceID(context);
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    ResourceContentResult _xifexpression = null;
                    _xifexpression = revert ? this.resourcePersistenceService.revert(resourceId, this.resourceHandler, context) : this.resourcePersistenceService.load(resourceId, this.resourceHandler, context);
                    _xtrycatchfinallyexpression = _xifexpression;
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
            ((ServiceDescriptor)it).hasSideEffects = revert;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getSaveResourceService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = this.resourcePersistenceService.save(document, this.resourceHandler, context);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
            ((ServiceDescriptor)it).hasSideEffects = true;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getUpdateDocumentService(IServiceContext context) throws InvalidRequestException {
        boolean initializedFromFullText;
        String resourceId = this.getResourceID(context);
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        String fullText = context.getParameter("fullText");
        XtextWebDocument document = this.getResourceDocument(resourceId, context);
        boolean bl = initializedFromFullText = document == null;
        if (initializedFromFullText) {
            if (fullText == null) {
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
            }
            document = this.getFullTextDocument(fullText, resourceId, context);
        }
        XtextWebDocumentAccess documentAccess = this.documentAccessFactory.create(document, context.getParameter("requiredStateId"), false);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> ((ServiceDescriptor)it).hasSideEffects = true;
        ServiceDescriptor result = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        if (fullText == null) {
            String deltaText = context.getParameter("deltaText");
            if (deltaText == null) {
                throw new InvalidRequestException.InvalidParametersException("One of the parameters 'deltaText' and 'fullText' must be specified.");
            }
            int deltaOffset = this.getInt(context, "deltaOffset", (Optional<Integer>)Optional.absent());
            if (deltaOffset < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
            }
            int deltaReplaceLength = this.getInt(context, "deltaReplaceLength", (Optional<Integer>)Optional.absent());
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
            }
            Functions.Function0 _function_1 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = this.updateDocumentService.updateDeltaText(documentAccess, deltaText, deltaOffset, deltaReplaceLength);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError(result, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            result.service = _function_1;
        } else {
            boolean _contains = context.getParameterKeys().contains("deltaText");
            if (_contains) {
                throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            Functions.Function0 _function_2 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    DocumentStateResult _xifexpression = null;
                    _xifexpression = initializedFromFullText ? this.updateDocumentService.getStateId(documentAccess) : this.updateDocumentService.updateFullText(documentAccess, fullText);
                    _xtrycatchfinallyexpression = _xifexpression;
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError(result, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            result.service = _function_2;
        }
        return result;
    }

    protected ServiceDescriptor getContentAssistService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int proposalsLimit = this.getInt(context, "proposalsLimit", (Optional<Integer>)Optional.of((Object)1000));
        if (proposalsLimit <= 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'proposalsLimit' must contain a positive integer.");
        }
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)offset));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        int _max = Math.max(selectionEnd - selectionStart, 0);
        TextRegion selection = new TextRegion(selectionStart, _max);
        String deltaText = context.getParameter("deltaText");
        ServiceDescriptor _xifexpression = null;
        if (deltaText == null) {
            ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
            Procedures.Procedure1 _function = it -> {
                Functions.Function0 _function_1 = () -> {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = this.contentAssistService.createProposals(document, (ITextRegion)selection, offset, proposalsLimit);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                ((ServiceDescriptor)it).service = _function_1;
            };
            _xifexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        } else {
            ServiceDescriptor _xblockexpression_1 = null;
            boolean _contains = context.getParameterKeys().contains("fullText");
            if (_contains) {
                throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            int deltaOffset = this.getInt(context, "deltaOffset", (Optional<Integer>)Optional.absent());
            if (deltaOffset < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
            }
            int deltaReplaceLength = this.getInt(context, "deltaReplaceLength", (Optional<Integer>)Optional.absent());
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
            }
            ServiceDescriptor _serviceDescriptor_1 = new ServiceDescriptor();
            Procedures.Procedure1 _function_1 = it -> {
                Functions.Function0 _function_2 = () -> {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = this.contentAssistService.createProposalsWithUpdate(document, deltaText, deltaOffset, deltaReplaceLength, (ITextRegion)selection, offset, proposalsLimit);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                ((ServiceDescriptor)it).service = _function_2;
                ((ServiceDescriptor)it).hasSideEffects = true;
            };
            _xifexpression = _xblockexpression_1 = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor_1, (Procedures.Procedure1)_function_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ServiceDescriptor getValidationService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                ServiceConflictResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = (ServiceConflictResult)this.validationService.getResult(document);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getHoverService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)offset));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        int _max = Math.max(selectionEnd - selectionStart, 0);
        TextRegion selection = new TextRegion(selectionStart, _max);
        String proposal = context.getParameter("proposal");
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    HoverResult _xifexpression = null;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)proposal);
                    _xifexpression = _isNullOrEmpty ? this.hoverService.getHover(document, offset) : this.hoverService.getHover(document, proposal, (ITextRegion)selection, offset);
                    _xtrycatchfinallyexpression = _xifexpression;
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getHighlightingService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                ServiceConflictResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = (ServiceConflictResult)this.highlightingService.getResult(document);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getOccurrencesService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            Functions.Function0 _function_1 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = this.occurrencesService.findOccurrences(document, offset);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_1;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getFormattingService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)0));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        String lineSeparator = context.getParameter("lineSeparator");
        String indentation = context.getParameter("indentation");
        int indentationLength = this.getInt(context, "indentationLength", (Optional<Integer>)Optional.of((Object)4));
        int maxLineWidth = this.getInt(context, "maxLineWidth", (Optional<Integer>)Optional.of((Object)120));
        CancelableUnitOfWork<IPreferenceValues, IXtextWebDocument> _function = new CancelableUnitOfWork<IPreferenceValues, IXtextWebDocument>(){

            public IPreferenceValues exec(IXtextWebDocument $0, CancelIndicator $1) throws Exception {
                IPreferenceValues _preferenceValues = null;
                if (XtextServiceDispatcher.this.formatterPreferencesProvider != null) {
                    _preferenceValues = XtextServiceDispatcher.this.formatterPreferencesProvider.getPreferenceValues((Resource)$0.getResource());
                }
                return _preferenceValues;
            }
        };
        IPreferenceValues formatterPreferences = document.readOnly(_function);
        LinkedHashMap _newLinkedHashMap = CollectionLiterals.newLinkedHashMap();
        MapBasedPreferenceValues preferences = new MapBasedPreferenceValues(formatterPreferences, (Map)_newLinkedHashMap);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.lineSeparator, (Object)lineSeparator);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.indentation, (Object)indentation);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.tabWidth, (Object)indentationLength);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.maxLineWidth, (Object)maxLineWidth);
        TextRegion _xifexpression = null;
        _xifexpression = selectionEnd > selectionStart ? new TextRegion(selectionStart, selectionEnd - selectionStart) : null;
        TextRegion selection = _xifexpression;
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function_1 = it -> {
            Functions.Function0 _function_2 = () -> {
                IServiceResult _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = this.formattingService.format(document, (ITextRegion)selection, (ITypedPreferenceValues)preferences);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable throwable = _t;
                        _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            };
            ((ServiceDescriptor)it).service = _function_2;
            ((ServiceDescriptor)it).hasSideEffects = true;
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function_1);
        return _xblockexpression;
    }

    protected ServiceDescriptor getGeneratorService(IServiceContext context) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        boolean allArtifacts = this.getBoolean(context, "allArtifacts", (Optional<Boolean>)Optional.of((Object)false));
        boolean includeContent = this.getBoolean(context, "includeContent", (Optional<Boolean>)Optional.of((Object)true));
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1 _function = it -> {
            if (allArtifacts) {
                Functions.Function0 _function_1 = () -> {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = this.generatorService.getResult(document, includeContent);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                ((ServiceDescriptor)it).service = _function_1;
            } else {
                String artifactId = context.getParameter("artifact");
                Functions.Function0 _function_2 = () -> {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = this.generatorService.getArtifact(document, artifactId, includeContent);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = this.handleError((ServiceDescriptor)it, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                ((ServiceDescriptor)it).service = _function_2;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected XtextWebDocumentAccess getDocumentAccess(IServiceContext context) throws InvalidRequestException {
        XtextWebDocument document = null;
        boolean initializedFromFullText = false;
        boolean _contains = context.getParameterKeys().contains("fullText");
        if (_contains) {
            document = this.getFullTextDocument(context.getParameter("fullText"), this.getResourceID(context), context);
            initializedFromFullText = true;
        } else {
            boolean _contains_1 = context.getParameterKeys().contains("resource");
            if (_contains_1) {
                document = this.getResourceDocument(this.getResourceID(context), context);
                if (document == null) {
                    throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
                }
            } else {
                throw new InvalidRequestException.InvalidParametersException("At least one of the parameters 'resource' and 'fullText' must be specified.");
            }
        }
        return this.documentAccessFactory.create(document, context.getParameter("requiredStateId"), initializedFromFullText);
    }

    protected String getResourceID(IServiceContext context) {
        return context.getParameter("resource");
    }

    protected XtextWebDocument getFullTextDocument(String fullText, String resourceId, IServiceContext context) {
        try {
            ResourceSet resourceSet = this.resourceSetProvider.get(resourceId, context);
            String _elvis = null;
            if (resourceId != null) {
                _elvis = resourceId;
            } else {
                String _plus_1;
                String _hexString = Integer.toHexString(this.randomGenerator.nextInt());
                String _plus = _hexString + ".";
                String _primaryFileExtension = this.fileExtensionProvider.getPrimaryFileExtension();
                _elvis = _plus_1 = _plus + _primaryFileExtension;
            }
            URI uri = URI.createURI((String)_elvis);
            Resource _createResource = this.resourceFactory.createResource(uri);
            XtextResource resource = (XtextResource)_createResource;
            Resource existingResource = resourceSet.getResource(uri, false);
            if (existingResource != null) {
                resourceSet.getResources().remove((Object)existingResource);
            }
            resourceSet.getResources().add((Object)resource);
            StringInputStream _stringInputStream = new StringInputStream(fullText);
            resource.load((InputStream)_stringInputStream, CollectionLiterals.emptyMap());
            XtextWebDocument document = this.documentProvider.get(resourceId, context);
            document.setInput(resource);
            if (resourceId != null) {
                ISession _session = context.getSession();
                Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
                _session.put(_mappedTo, document);
            }
            return document;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected XtextWebDocument getResourceDocument(String resourceId, IServiceContext context) {
        try {
            ISession _session = context.getSession();
            Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
            Functions.Function0 _function = () -> {
                try {
                    return this.resourceHandler.get(resourceId, context);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            XtextWebDocument document = (XtextWebDocument)_session.get(_mappedTo, _function);
            return document;
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException ioe = (IOException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String getString(IServiceContext context, String key, Optional<String> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (String)defaultValue.get();
        }
        return stringValue;
    }

    protected int getInt(IServiceContext context, String key, Optional<Integer> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (Integer)defaultValue.get();
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException nfe = (NumberFormatException)_t;
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain an integer value.");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean getBoolean(IServiceContext context, String key, Optional<Boolean> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (Boolean)defaultValue.get();
        }
        String _lowerCase = stringValue.toLowerCase();
        if (_lowerCase != null) {
            switch (_lowerCase) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain a Boolean value.");
        }
        throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain a Boolean value.");
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, Throwable throwable) {
        try {
            boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(throwable);
            if (_isOperationCanceledException) {
                String _parameter = service.context.getParameter("serviceType");
                String _plus = "Service canceled (" + _parameter;
                String _plus_1 = _plus + ")";
                LOG.trace((Object)_plus_1);
                return new ServiceConflictResult("canceled");
            }
            throw throwable;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, InvalidRequestException.InvalidDocumentStateException exception) {
        String _parameter = service.context.getParameter("serviceType");
        String _plus = "Invalid document state (" + _parameter;
        String _plus_1 = _plus + ")";
        LOG.trace((Object)_plus_1);
        return new ServiceConflictResult("invalidStateId");
    }

    protected ServiceConflictResult handleError(ServiceDescriptor service, Throwable exception) {
        if (exception instanceof InvalidRequestException.InvalidDocumentStateException) {
            return this._handleError(service, (InvalidRequestException.InvalidDocumentStateException)exception);
        }
        if (exception != null) {
            return this._handleError(service, exception);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(service, exception).toString());
    }

    @Accessors
    @ToString
    public static class ServiceDescriptor {
        private IServiceContext context;
        private Functions.Function0<? extends IServiceResult> service;
        private boolean hasSideEffects;
        private boolean hasConflict;

        @Pure
        public IServiceContext getContext() {
            return this.context;
        }

        public void setContext(IServiceContext context) {
            this.context = context;
        }

        @Pure
        public Functions.Function0<? extends IServiceResult> getService() {
            return this.service;
        }

        public void setService(Functions.Function0<? extends IServiceResult> service) {
            this.service = service;
        }

        @Pure
        public boolean isHasSideEffects() {
            return this.hasSideEffects;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        @Pure
        public boolean isHasConflict() {
            return this.hasConflict;
        }

        public void setHasConflict(boolean hasConflict) {
            this.hasConflict = hasConflict;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("context", (Object)this.context);
            b.add("service", this.service);
            b.add("hasSideEffects", (Object)this.hasSideEffects);
            b.add("hasConflict", (Object)this.hasConflict);
            return b.toString();
        }
    }
}

