/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Singleton;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;

@Singleton
public class UpdateDocumentService {
    public DocumentStateResult updateFullText(XtextWebDocumentAccess document, final String fullText) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.setDirty(true);
                it.createNewStateId();
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.setText(fullText);
                return null;
            }
        };
        return document.modify(_function, _function_1);
    }

    public DocumentStateResult updateDeltaText(XtextWebDocumentAccess document, final String deltaText, final int offset, final int replaceLength) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                it.setDirty(true);
                it.createNewStateId();
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                boolean _lessEqualsThan;
                String _text = it.getText();
                int _length = _text.length();
                boolean bl = _lessEqualsThan = offset <= _length;
                if (_lessEqualsThan) {
                    it.updateText(deltaText, offset, replaceLength);
                }
                return null;
            }
        };
        return document.modify(_function, _function_1);
    }

    public DocumentStateResult getStateId(XtextWebDocumentAccess document) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        return document.modify(_function);
    }
}

