/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.hover;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.labels.AlternativeImageDescription;
import org.eclipse.xtext.ide.labels.DecoratedImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescriptionProvider;
import org.eclipse.xtext.ide.labels.INameLabelProvider;
import org.eclipse.xtext.ide.labels.SimpleImageDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.hover.HoverResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.util.ElementAtOffsetUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class HoverService {
    @Inject
    @Extension
    private ElementAtOffsetUtil _elementAtOffsetUtil;
    @Inject
    @Extension
    private IEObjectDocumentationProvider _iEObjectDocumentationProvider;
    @Inject
    @Extension
    private IImageDescriptionProvider _iImageDescriptionProvider;
    @Inject
    @Extension
    private INameLabelProvider _iNameLabelProvider;
    @Inject
    @Extension
    private OperationCanceledManager _operationCanceledManager;
    @Inject
    private ContentAssistService contentAssistService;

    public HoverResult getHover(XtextWebDocumentAccess document, final int offset) throws InvalidRequestException {
        CancelableUnitOfWork<HoverResult, IXtextWebDocument> _function = new CancelableUnitOfWork<HoverResult, IXtextWebDocument>(){

            public HoverResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                HoverResult _xblockexpression = null;
                XtextResource _resource = it.getResource();
                EObject element = HoverService.this._elementAtOffsetUtil.getElementAt(_resource, offset);
                String _stateId = it.getStateId();
                _xblockexpression = HoverService.this.createHover(element, _stateId, cancelIndicator);
                return _xblockexpression;
            }
        };
        return document.readOnly(_function);
    }

    public HoverResult getHover(XtextWebDocumentAccess document, final String proposal, final ITextRegion selection, final int offset) throws InvalidRequestException {
        CancelableUnitOfWork<HoverResult, IXtextWebDocument> _function = new CancelableUnitOfWork<HoverResult, IXtextWebDocument>(){

            public HoverResult exec(IXtextWebDocument it, final CancelIndicator cancelIndicator) throws Exception {
                HoverResult _xblockexpression = null;
                ContentAssistContext[] contexts = HoverService.this.contentAssistService.getContexts(it, selection, offset);
                final Wrapper proposedElement = new Wrapper();
                IdeContentProposalProvider _proposalProvider = HoverService.this.contentAssistService.getProposalProvider();
                _proposalProvider.createProposals((Collection)Conversions.doWrapArray((Object)contexts), new IIdeContentProposalAcceptor(){

                    public void accept(ContentAssistEntry entry, int priority) {
                        HoverService.this._operationCanceledManager.checkCanceled(cancelIndicator);
                        if (entry != null && entry.getSource() != null && Objects.equal((Object)entry.getProposal(), (Object)proposal)) {
                            Object _source = entry.getSource();
                            proposedElement.set(_source);
                        }
                    }

                    public boolean canAcceptMoreProposals() {
                        Object _get = proposedElement.get();
                        return _get == null;
                    }
                });
                Object _get = proposedElement.get();
                String _stateId = it.getStateId();
                _xblockexpression = HoverService.this.createHover(_get, _stateId, cancelIndicator);
                return _xblockexpression;
            }
        };
        return document.readOnly(_function);
    }

    protected HoverResult createHover(Object element, String stateId, CancelIndicator cancelIndicator) {
        String nameLabel;
        String _nameLabel = null;
        if (element != null) {
            _nameLabel = this._iNameLabelProvider.getNameLabel(element);
        }
        String _surroundWithDiv = null;
        if (_nameLabel != null) {
            _surroundWithDiv = this.surroundWithDiv(_nameLabel, "element-name");
        }
        if ((nameLabel = _surroundWithDiv) != null) {
            String documentation;
            this._operationCanceledManager.checkCanceled(cancelIndicator);
            IImageDescription _imageDescription = this._iImageDescriptionProvider.getImageDescription(element);
            String _addIconDivs = this.addIconDivs(_imageDescription, nameLabel);
            String titleHtml = this.surroundWithDiv(_addIconDivs, "xtext-hover");
            this._operationCanceledManager.checkCanceled(cancelIndicator);
            EObject _switchResult = null;
            boolean _matched = false;
            if (element instanceof EObject) {
                _matched = true;
                _switchResult = (EObject)element;
            }
            if (!_matched && element instanceof IEObjectDescription) {
                _matched = true;
                _switchResult = ((IEObjectDescription)element).getEObjectOrProxy();
            }
            EObject eobject = _switchResult;
            String bodyHtml = "";
            if (eobject != null && !eobject.eIsProxy() && (documentation = this._iEObjectDocumentationProvider.getDocumentation(eobject)) != null) {
                String _surroundWithDiv_1;
                bodyHtml = _surroundWithDiv_1 = this.surroundWithDiv(documentation, "xtext-hover");
            }
            return new HoverResult(stateId, titleHtml, bodyHtml);
        }
        return new HoverResult(stateId);
    }

    protected String addIconDivs(IImageDescription it, String nameHtml) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof SimpleImageDescription) {
            _matched = true;
            String _imageID = ((SimpleImageDescription)it).getImageID();
            String _plus = _imageID + "-icon";
            _switchResult = this.surroundWithDiv(nameHtml, _plus);
        }
        if (!_matched && it instanceof AlternativeImageDescription) {
            _matched = true;
            List _imageIDs = ((AlternativeImageDescription)it).getImageIDs();
            Functions.Function1 _function = it_1 -> it_1 + "-icon";
            List _map = ListExtensions.map((List)_imageIDs, (Functions.Function1)_function);
            _switchResult = this.surroundWithDiv(nameHtml, (String[])Conversions.unwrapArray((Object)_map, String.class));
        }
        if (!_matched && it instanceof DecoratedImageDescription) {
            _matched = true;
            List _decorators = ((DecoratedImageDescription)it).getDecorators();
            IImageDescription _baseImage = ((DecoratedImageDescription)it).getBaseImage();
            Iterable _plus = Iterables.concat((Iterable)_decorators, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IImageDescription[]{_baseImage})));
            Functions.Function2 _function = ($0, $1) -> this.addIconDivs((IImageDescription)$1, (String)$0);
            _switchResult = (String)IterableExtensions.fold((Iterable)_plus, (Object)nameHtml, (Functions.Function2)_function);
        }
        return _switchResult;
    }

    protected String surroundWithDiv(String html, String ... divClasses) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<div");
        int _length = divClasses.length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append(" class=\"");
            String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)divClasses)), (CharSequence)" ");
            _builder.append(_join, "");
            _builder.append("\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(html, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</div>");
        _builder.newLine();
        return _builder.toString();
    }
}

