/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.ISessionStore;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.web.servlet.HttpServletSessionStore;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XtextServlet
extends HttpServlet {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private final IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    private final Gson gson = new Gson();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException) {
                InvalidRequestException ire = (InvalidRequestException)_t;
                String _requestURI = req.getRequestURI();
                String _plus = "Invalid request (" + _requestURI;
                String _plus_1 = _plus + "): ";
                String _message = ire.getMessage();
                String _plus_2 = _plus_1 + _message;
                this.LOG.trace((Object)_plus_2);
                int _switchResult = 0;
                InvalidRequestException.Type _type = ire.getType();
                if (_type != null) {
                    switch (_type) {
                        case RESOURCE_NOT_FOUND: {
                            _switchResult = 404;
                            break;
                        }
                        case INVALID_DOCUMENT_STATE: {
                            _switchResult = 409;
                            break;
                        }
                        default: {
                            _switchResult = 400;
                            break;
                        }
                    }
                } else {
                    _switchResult = 400;
                }
                int statusCode = _switchResult;
                String _message_1 = ire.getMessage();
                resp.sendError(statusCode, _message_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _isHasTextInput;
            boolean _or = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            _or = _isHasSideEffects ? true : (_isHasTextInput = service.isHasTextInput());
            _and = _or;
        }
        if (_and) {
            super.doGet(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String _type;
        boolean _notEquals;
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        _and = !_not ? false : (_notEquals = !Objects.equal((Object)(_type = service.getType()), (Object)"update"));
        if (_and) {
            super.doPut(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _isHasTextInput;
            boolean _not_2;
            boolean _not_1;
            boolean _or = false;
            boolean _and_1 = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            boolean bl2 = _not_1 = !_isHasSideEffects;
            _and_1 = !_not_1 ? false : (_not_2 = !(_isHasTextInput = service.isHasTextInput()));
            if (_and_1) {
                _or = true;
            } else {
                boolean _equals;
                String _type = service.getType();
                _or = _equals = Objects.equal((Object)_type, (Object)"update");
            }
            _and = _or;
        }
        if (_and) {
            super.doPost(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doService(XtextServiceDispatcher.ServiceDescriptor service, HttpServletResponse resp) {
        try {
            Functions.Function0 _service = service.getService();
            IServiceResult result = (IServiceResult)_service.apply();
            resp.setStatus(200);
            resp.setContentType("text/x-json;charset=UTF-8");
            resp.setHeader("Cache-Control", "no-cache");
            PrintWriter _writer = resp.getWriter();
            this.gson.toJson((Object)result, (Appendable)_writer);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected XtextServiceDispatcher.ServiceDescriptor getService(HttpServletRequest req) {
        try {
            HttpSession _session = req.getSession();
            HttpServletSessionStore sessionStore = new HttpServletSessionStore(_session);
            Map<String, String> parameters = this.getParameterMap(req);
            Injector injector = this.getInjector(parameters);
            XtextServiceDispatcher serviceDispatcher = (XtextServiceDispatcher)injector.getInstance(XtextServiceDispatcher.class);
            String _elvis = null;
            String _pathInfo = req.getPathInfo();
            _elvis = _pathInfo != null ? _pathInfo : "";
            return serviceDispatcher.getService(_elvis, parameters, (ISessionStore)sessionStore);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Map<String, String> getParameterMap(HttpServletRequest req) {
        Map _parameterMap;
        Map paramMultiMap = _parameterMap = req.getParameterMap();
        int _size = paramMultiMap.size();
        final HashMap result = Maps.newHashMapWithExpectedSize((int)_size);
        Set _entrySet = paramMultiMap.entrySet();
        Functions.Function1<Map.Entry<String, String[]>, Boolean> _function = new Functions.Function1<Map.Entry<String, String[]>, Boolean>(){

            public Boolean apply(Map.Entry<String, String[]> it) {
                String[] _value = it.getValue();
                int _length = _value.length;
                return _length > 0;
            }
        };
        Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Procedures.Procedure1<Map.Entry<String, String[]>> _function_1 = new Procedures.Procedure1<Map.Entry<String, String[]>>(){

            public void apply(Map.Entry<String, String[]> it) {
                String _key = it.getKey();
                String[] _value = it.getValue();
                String _get = _value[0];
                result.put(_key, _get);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
        return Collections.unmodifiableMap(result);
    }

    protected Injector getInjector(Map<String, String> parameters) throws InvalidRequestException {
        IResourceServiceProvider _resourceServiceProvider_1;
        IResourceServiceProvider _resourceServiceProvider;
        IResourceServiceProvider resourceServiceProvider = null;
        String _elvis = null;
        String _get = parameters.get("resource");
        _elvis = _get != null ? _get : "";
        URI emfURI = URI.createURI((String)_elvis);
        String contentType = parameters.get("contentType");
        resourceServiceProvider = contentType == null ? (_resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI)) : (_resourceServiceProvider_1 = this.serviceProviderRegistry.getResourceServiceProvider(emfURI, contentType));
        boolean _equals = Objects.equal((Object)resourceServiceProvider, null);
        if (_equals) {
            throw new InvalidRequestException(InvalidRequestException.Type.UNKNOWN_LANGUAGE, "Unable to identify the Xtext language.");
        }
        return (Injector)resourceServiceProvider.get(Injector.class);
    }
}

