/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.common.io.CharStreams;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.ISession;
import org.eclipse.xtext.web.servlet.HttpSessionWrapper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class HttpServiceContext
implements IServiceContext {
    @Accessors
    private final HttpServletRequest request;
    private final Map<String, String> parameters = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private HttpSessionWrapper sessionWrapper;

    public HttpServiceContext(HttpServletRequest request) {
        this.request = request;
        this.initializeParameters();
    }

    private String initializeParameters() {
        try {
            boolean _not;
            String[] contentType;
            String _xblockexpression = null;
            String _contentType = this.request.getContentType();
            String[] _split = null;
            if (_contentType != null) {
                _split = _contentType.split(";(\\s*)");
            }
            if ((contentType = _split) != null && Objects.equal((Object)contentType[0], (Object)"application/x-www-form-urlencoded")) {
                String[] encodedParams;
                String _xifexpression = null;
                _xifexpression = contentType != null && contentType.length >= 2 && contentType[1].startsWith("charset=") ? contentType[1].substring("charset=".length()) : Charset.defaultCharset().toString();
                String charset = _xifexpression;
                for (String param : encodedParams = CharStreams.toString((Readable)this.request.getReader()).split("&")) {
                    int nameEnd = param.indexOf("=");
                    if (nameEnd <= 0) continue;
                    String key = param.substring(0, nameEnd);
                    String value = URLDecoder.decode(param.substring(nameEnd + 1), charset);
                    this.parameters.put(key, value);
                }
            }
            Enumeration paramNames = this.request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                this.parameters.put(name, this.request.getParameter(name));
            }
            String _xifexpression_1 = null;
            boolean _containsKey = this.parameters.containsKey("serviceType");
            boolean bl = _not = !_containsKey;
            if (_not) {
                String _pathInfo = this.request.getPathInfo();
                String _substring = null;
                if (_pathInfo != null) {
                    _substring = _pathInfo.substring(1);
                }
                _xifexpression_1 = this.parameters.put("serviceType", _substring);
            }
            _xblockexpression = _xifexpression_1;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<String> getParameterKeys() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public ISession getSession() {
        if (this.sessionWrapper == null) {
            HttpSessionWrapper _httpSessionWrapper;
            HttpSession _session = this.request.getSession(true);
            this.sessionWrapper = _httpSessionWrapper = new HttpSessionWrapper(_session);
        }
        return this.sessionWrapper;
    }

    @Pure
    public HttpServletRequest getRequest() {
        return this.request;
    }
}

