/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.logging;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.junit.Assert;

@Beta
public class LoggingTester {
    private static final Comparator<LogEntry> TEMPORAL_ORDER = ($0, $1) -> Longs.compare((long)((LogEntry)$0).timeStamp, (long)((LogEntry)$1).timeStamp);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogCapture captureLogging(Level level, Class<?> source, Runnable action) {
        Logger logger = Logger.getLogger(source);
        QueueAppender appender = new QueueAppender();
        Level oldLevel = logger.getLevel();
        ArrayList<Appender> allAppenders = LoggingTester.appenderHierarchy(logger);
        SourceFilter filter = new SourceFilter(logger);
        try {
            Consumer<Appender> _function = it -> it.addFilter((Filter)filter);
            allAppenders.forEach(_function);
            logger.addAppender((Appender)appender);
            logger.setLevel(level);
            action.run();
            List _list = IterableExtensions.toList((Iterable)appender.events);
            List events = IterableExtensions.sortWith((Iterable)_list, TEMPORAL_ORDER);
            LogCapture logCapture = new LogCapture(events);
            return logCapture;
        }
        finally {
            logger.removeAppender((Appender)appender);
            Consumer<Appender> _function_1 = it -> LoggingTester.removeFilter(it, filter);
            allAppenders.forEach(_function_1);
            logger.setLevel(oldLevel);
        }
    }

    private static ArrayList<Appender> appenderHierarchy(Logger logger) {
        ArrayList _xblockexpression = null;
        ArrayList appenders = CollectionLiterals.newArrayList((Object[])new Appender[0]);
        for (Logger current = logger; current != null; current = current.getParent()) {
            Enumeration _allAppenders = current.getAllAppenders();
            ArrayList _list = Collections.list(_allAppenders);
            appenders.addAll(_list);
        }
        _xblockexpression = appenders;
        return _xblockexpression;
    }

    private static void removeFilter(Appender appender, Filter filter) {
        Filter _filter = appender.getFilter();
        boolean _equals = Objects.equal((Object)_filter, (Object)filter);
        if (_equals) {
            appender.clearFilters();
            Filter _next = filter.getNext();
            appender.addFilter(_next);
        } else {
            for (Filter current = appender.getFilter(); current != null; current = current.getNext()) {
                Filter _next_1 = current.getNext();
                boolean _equals_1 = Objects.equal((Object)_next_1, (Object)filter);
                if (!_equals_1) continue;
                Filter _next_2 = filter.getNext();
                current.setNext(_next_2);
                return;
            }
        }
    }

    @Data
    private static class SourceFilter
    extends Filter {
        private final Logger source;

        public int decide(LoggingEvent event) {
            String _name;
            int _xifexpression = 0;
            String _loggerName = event.getLoggerName();
            boolean _equals = Objects.equal((Object)_loggerName, (Object)(_name = this.source.getName()));
            _xifexpression = _equals ? -1 : 0;
            return _xifexpression;
        }

        public SourceFilter(Logger source) {
            this.source = source;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SourceFilter other = (SourceFilter)((Object)obj);
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Logger getSource() {
            return this.source;
        }
    }

    private static class QueueAppender
    extends AppenderSkeleton {
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private final Queue<LogEntry> events = new ConcurrentLinkedQueue<LogEntry>();

        private QueueAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent event) {
            String _renderedMessage = event.getRenderedMessage();
            String _loggerName = event.getLoggerName();
            long _timeStamp = event.getTimeStamp();
            Level _level = event.getLevel();
            LogEntry entry = new LogEntry(_renderedMessage, _loggerName, _timeStamp, _level);
            this.events.add(entry);
        }

        @Pure
        public Queue<LogEntry> getEvents() {
            return this.events;
        }
    }

    @Data
    public static class LogEntry {
        private final String message;
        private final String source;
        private final long timeStamp;
        private final Level level;

        public LogEntry(String message, String source, long timeStamp, Level level) {
            this.message = message;
            this.source = source;
            this.timeStamp = timeStamp;
            this.level = level;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogEntry other = (LogEntry)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            if (other.timeStamp != this.timeStamp) {
                return false;
            }
            return !(this.level == null ? other.level != null : !this.level.equals((Object)other.level));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("message", (Object)this.message);
            b.add("source", (Object)this.source);
            b.add("timeStamp", (Object)this.timeStamp);
            b.add("level", (Object)this.level);
            return b.toString();
        }

        @Pure
        public String getMessage() {
            return this.message;
        }

        @Pure
        public String getSource() {
            return this.source;
        }

        @Pure
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Pure
        public Level getLevel() {
            return this.level;
        }
    }

    @Data
    public static class LogCapture {
        private final List<LogEntry> logEntries;

        public void assertNoLogEntries() {
            this.assertNumberOfLogEntries(0);
        }

        public void assertLogEntry(String ... messageParts) {
            this.assertNumberOfLogEntries(1, messageParts);
        }

        public void assertLogEntry(Level level, String ... messageParts) {
            this.assertNumberOfLogEntries(1, level, messageParts);
        }

        public void assertNumberOfLogEntries(int number) {
            this.assertNumberOfLogEntries(number, new String[0]);
        }

        public void assertNumberOfLogEntries(int number, String ... messageParts) {
            this.assertNumberOfLogEntries(number, (Level)null, messageParts);
        }

        public void assertNumberOfLogEntries(int number, Level level, String ... messageParts) {
            boolean _notEquals;
            Functions.Function1 _function = log -> (level == null || Objects.equal((Object)((LogEntry)log).level, (Object)level)) && IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)messageParts)), it -> ((LogEntry)log).message.contains((CharSequence)it));
            Iterable passed = IterableExtensions.filter(this.logEntries, (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)passed);
            boolean bl = _notEquals = _size != number;
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                if (number == 0) {
                    _builder.append("Expected no log entries");
                    _builder.newLine();
                } else if (number == 1) {
                    _builder.append("Expected a log entry");
                    _builder.newLine();
                } else {
                    _builder.append("Expected ");
                    _builder.append((Object)number, "");
                    _builder.append(" log entries");
                    _builder.newLineIfNotEmpty();
                }
                if (level != null) {
                    _builder.append("with ");
                    _builder.append((Object)level, "");
                    _builder.append(" level");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("containing the phrases ");
                Functions.Function1 _function_1 = it -> "\"" + it + "\"";
                String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)messageParts)), (CharSequence)", ", (Functions.Function1)_function_1);
                _builder.append(_join, "");
                _builder.newLineIfNotEmpty();
                _builder.append("but got");
                _builder.newLine();
                _builder.append(this.logEntries, "");
                _builder.newLineIfNotEmpty();
                Assert.fail((String)_builder.toString());
            }
        }

        public LogCapture(List<LogEntry> logEntries) {
            this.logEntries = logEntries;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.logEntries == null ? 0 : this.logEntries.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogCapture other = (LogCapture)obj;
            return !(this.logEntries == null ? other.logEntries != null : !this.logEntries.equals(other.logEntries));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("logEntries", this.logEntries);
            return b.toString();
        }

        @Pure
        public List<LogEntry> getLogEntries() {
            return this.logEntries;
        }
    }
}

