/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.common.base.Objects;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJavaSchemeUriResolver;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.java.resource.JavaDerivedStateComputer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaResource
extends ResourceImpl
implements IJavaSchemeUriResolver,
ISynchronizable<JavaResource> {
    public static final String OPTION_ENCODING = String.valueOf(JavaResource.class.getName()) + ".DEFAULT_ENCODING";
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private JavaDerivedStateComputer derivedStateComputer;
    private CompilationUnit compilationUnit;
    private boolean isInitialized = false;
    private boolean isFullyInitialized = false;
    private boolean isInitializing = false;
    private IndexedJvmTypeAccess _access;

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        CompilationUnit _compilationUnit;
        URI _uRI = this.getURI();
        String encoding = this.getEncoding(_uRI, options);
        InputStreamReader _inputStreamReader = new InputStreamReader(inputStream, encoding);
        String contentsAsString = CharStreams.toString((Readable)_inputStreamReader);
        char[] _charArray = contentsAsString.toCharArray();
        URI _uRI_1 = this.getURI();
        String _lastSegment = _uRI_1.lastSegment();
        this.compilationUnit = _compilationUnit = new CompilationUnit(_charArray, _lastSegment, encoding);
    }

    protected String getEncoding(URI uri, Map<?, ?> options) {
        Object encodingOption;
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(options, null);
        if (_notEquals && (encodingOption = options.get(OPTION_ENCODING)) instanceof String) {
            return (String)encodingOption;
        }
        return this.encodingProvider.getEncoding(uri);
    }

    protected CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> getContents() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isInitializing) {
                return super.getContents();
            }
            try {
                this.isInitializing = true;
                boolean isIndexing = this.compilerPhases.isIndexing((Notifier)this);
                if (!isIndexing && !this.isFullyInitialized) {
                    this.derivedStateComputer.discardDerivedState((Resource)this);
                    this.derivedStateComputer.installFull((Resource)this);
                    this.isFullyInitialized = true;
                    this.isInitialized = true;
                } else {
                    boolean _and = false;
                    if (!isIndexing) {
                        _and = false;
                    } else {
                        boolean bl = _and = !this.isInitialized;
                    }
                    if (_and) {
                        this.derivedStateComputer.installStubs((Resource)this);
                        this.isFullyInitialized = false;
                        this.isInitialized = true;
                    }
                }
            }
            finally {
                this.isInitializing = false;
            }
            return super.getContents();
        }
    }

    public EObject resolveJavaObjectURIProxy(InternalEObject proxy, JvmTypeReference sender) {
        boolean _notEquals;
        IndexedJvmTypeAccess access = this.getIndexJvmTypeAccess();
        boolean bl = _notEquals = !Objects.equal((Object)access, null);
        if (_notEquals) {
            boolean _notEquals_1;
            ResourceSet _resourceSet;
            URI _eProxyURI = proxy.eProxyURI();
            EObject result = access.getIndexedJvmType(_eProxyURI, _resourceSet = this.getResourceSet());
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)result, null);
            if (_notEquals_1) {
                return result;
            }
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)sender);
    }

    public IndexedJvmTypeAccess getIndexJvmTypeAccess() {
        Resource.Factory.Registry _resourceFactoryRegistry;
        Map _protocolToFactoryMap;
        Object provider;
        boolean _equals = Objects.equal((Object)this._access, null);
        if (_equals && (provider = (_protocolToFactoryMap = (_resourceFactoryRegistry = this.resourceSet.getResourceFactoryRegistry()).getProtocolToFactoryMap()).get("java")) instanceof AbstractJvmTypeProvider) {
            IndexedJvmTypeAccess _indexedJvmTypeAccess;
            this._access = _indexedJvmTypeAccess = ((AbstractJvmTypeProvider)provider).getIndexedJvmTypeAccess();
        }
        return this._access;
    }

    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> Result execute(IUnitOfWork<Result, ? super JavaResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    public static class Factory
    implements Resource.Factory {
        @Inject
        private Provider<JavaResource> resourceProvider;

        public Resource createResource(final URI uri) {
            JavaResource _get = (JavaResource)((Object)this.resourceProvider.get());
            Procedures.Procedure1<JavaResource> _function = new Procedures.Procedure1<JavaResource>(){

                public void apply(JavaResource it) {
                    it.setURI(uri);
                }
            };
            return (Resource)ObjectExtensions.operator_doubleArrow((Object)((Object)_get), (Procedures.Procedure1)_function);
        }
    }
}

