/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequestManager;
import org.eclipse.xtext.ide.server.concurrent.Cancellable;
import org.eclipse.xtext.ide.server.concurrent.RequestCancelIndicator;

public abstract class AbstractRequest<V>
implements Runnable,
Cancellable {
    protected final ResultFuture result;
    protected final RequestCancelIndicator cancelIndicator;
    protected final AbstractRequestManager requestManager;

    protected AbstractRequest(AbstractRequestManager requestManager) {
        this.requestManager = requestManager;
        this.result = new ResultFuture();
        this.cancelIndicator = new RequestCancelIndicator(this);
    }

    protected void cancelResult(boolean mayInterruptIfRunning) {
        this.result.doCancel(mayInterruptIfRunning);
    }

    protected boolean isDone() {
        return this.result.isDone();
    }

    protected void complete(V value) {
        this.result.complete(value);
    }

    protected abstract Logger getLogger();

    protected void logAndCompleteExceptionally(Throwable t) {
        if (!this.requestManager.isCancelException(t)) {
            this.getLogger().error((Object)"Error during request: ", t);
            this.result.completeExceptionally(t);
        } else {
            this.cancelResult(true);
        }
    }

    protected void cancel(boolean mayInterruptIfRunning) {
        this.cancelIndicator.doCancel();
    }

    @Override
    public final void cancel() {
        this.cancel(true);
    }

    public CompletableFuture<V> get() {
        return this.result;
    }

    private class ResultFuture
    extends CompletableFuture<V> {
        private ResultFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AbstractRequest.this.cancel(mayInterruptIfRunning);
            return this.isCancelled();
        }

        void doCancel(boolean mayInterruptIfRunning) {
            super.cancel(mayInterruptIfRunning);
        }
    }
}

