/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.quickfix;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticModificationContext;
import org.eclipse.xtext.ide.editor.quickfix.ISemanticModification;
import org.eclipse.xtext.ide.editor.quickfix.ITextModification;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.TextEditAcceptor;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.rename.ChangeConverter2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;

public class DiagnosticResolution {
    private String label;
    private ISemanticModification modification;
    private final ITextModification textModification;
    private DiagnosticModificationContext.Factory factory;
    private int relevance;
    private URI uri;
    private Document document;
    private ILanguageServerAccess access;
    private Diagnostic diagnostic;
    private static Logger log = Logger.getLogger(DiagnosticResolution.class);

    @Deprecated
    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, IChangeSerializer.IModification<EObject> modification) {
        this(label, modificationContextFactory, (Diagnostic diagnostic, EObject object) -> modification, 0);
    }

    @Deprecated
    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, IChangeSerializer.IModification<EObject> modification, int relevance) {
        this(label, modificationContextFactory, (Diagnostic diagnostic, EObject object) -> modification, relevance);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, ITextModification textModification) {
        this(label, modificationContextFactory, textModification, 0);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, ITextModification textModification, int relevance) {
        this.label = label;
        this.factory = modificationContextFactory;
        this.modification = null;
        this.textModification = textModification;
        this.relevance = relevance;
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, ISemanticModification modification) {
        this(label, modificationContextFactory, modification, 0);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContext, ISemanticModification modification, int relevance) {
        this.label = label;
        this.factory = modificationContext;
        this.modification = modification;
        this.textModification = null;
        this.relevance = relevance;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getLabel() {
        return this.label;
    }

    private EObject getContextObject() {
        ResourceSet resourceSet = this.access.newLiveScopeResourceSet(this.uri);
        XtextResource tmpResource = (XtextResource)resourceSet.getResource(this.uri, true);
        EObjectAtOffsetHelper eObjectAtOffsetHelper = (EObjectAtOffsetHelper)tmpResource.getResourceServiceProvider().get(EObjectAtOffsetHelper.class);
        if (eObjectAtOffsetHelper == null) {
            return null;
        }
        int offset = this.document.getOffSet(this.diagnostic.getRange().getStart());
        return eObjectAtOffsetHelper.resolveContainedElementAt(tmpResource, offset);
    }

    public WorkspaceEdit apply() {
        try {
            EObject obj = this.getContextObject();
            if (obj == null) {
                return null;
            }
            WorkspaceEdit edit = new WorkspaceEdit();
            if (this.modification != null) {
                DiagnosticModificationContext modificationContext = this.factory.createModificationContext();
                ChangeConverter2 changeConverter = modificationContext.getConverterFactory().create(edit, this.access);
                IChangeSerializer serializer = modificationContext.getSerializer();
                serializer.addModification(obj, this.modification.apply(this.diagnostic, obj));
                serializer.applyModifications(changeConverter);
            } else {
                TextEditAcceptor textEditAcceptor = new TextEditAcceptor(edit, this.access);
                textEditAcceptor.accept(this.uri.toString(), this.document, this.textModification.apply(this.diagnostic, obj, this.document));
            }
            return edit;
        }
        catch (Exception exc) {
            log.error((Object)"Creation of WorkspaceEdit failed.", (Throwable)exc);
            return null;
        }
    }

    void configure(ICodeActionService2.Options options, Diagnostic diagnostic) {
        this.uri = options.getResource().getURI();
        this.document = options.getDocument();
        this.access = options.getLanguageServerAccess();
        this.diagnostic = diagnostic;
    }
}

