/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.quickfix;

import com.google.common.collect.MoreCollectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticModificationContext;
import org.eclipse.xtext.ide.editor.quickfix.ITextModification;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.TextEditAcceptor;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.rename.ChangeConverter2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;

public class DiagnosticResolution {
    private String label;
    private IChangeSerializer.IModification<EObject> modification;
    private final ITextModification textModification;
    private DiagnosticModificationContext.Factory factory;
    private int relevance;
    private ICodeActionService2.Options options;

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, ITextModification textModification) {
        this(label, modificationContextFactory, textModification, 0);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, ITextModification textModification, int relevance) {
        this.label = label;
        this.factory = modificationContextFactory;
        this.modification = null;
        this.textModification = textModification;
        this.relevance = relevance;
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, IChangeSerializer.IModification<EObject> modification) {
        this(label, modificationContextFactory, modification, 0);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContext, IChangeSerializer.IModification<EObject> modification, int relevance) {
        this.label = label;
        this.factory = modificationContext;
        this.modification = modification;
        this.textModification = null;
        this.relevance = relevance;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getLabel() {
        return this.label;
    }

    public WorkspaceEdit apply() {
        try {
            XtextResource resource = this.options.getResource();
            URI uri = resource.getURI();
            CodeActionParams params = this.options.getCodeActionParams();
            Document document = this.options.getDocument();
            int offset = document.getOffSet(params.getRange().getStart());
            EObjectAtOffsetHelper helper = new EObjectAtOffsetHelper();
            ILanguageServerAccess access = this.options.getLanguageServerAccess();
            ResourceSet resourceSet = access.newLiveScopeResourceSet(uri);
            XtextResource tmpResource = (XtextResource)resourceSet.getResource(uri, true);
            EObject obj = helper.resolveContainedElementAt(tmpResource, offset);
            WorkspaceEdit edit = new WorkspaceEdit();
            if (this.modification != null) {
                DiagnosticModificationContext modificationContext = this.factory.createModificationContext();
                ChangeConverter2 changeConverter = modificationContext.getConverterFactory().create(edit, access);
                IChangeSerializer serializer = modificationContext.getSerializer();
                serializer.addModification(obj, this.modification);
                serializer.applyModifications(changeConverter);
            } else {
                TextEditAcceptor textEditAcceptor = new TextEditAcceptor(edit, access);
                Diagnostic diagnostic = (Diagnostic)params.getContext().getDiagnostics().stream().collect(MoreCollectors.onlyElement());
                textEditAcceptor.accept(uri.toString(), document, this.textModification.apply(diagnostic, obj, document));
            }
            return edit;
        }
        catch (Exception exc) {
            throw new WrappedException(exc);
        }
    }

    void configure(ICodeActionService2.Options options) {
        this.options = options;
    }
}

