/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.folding;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.ide.editor.folding.DefaultFoldingRangeAcceptor;
import org.eclipse.xtext.ide.editor.folding.FoldingRange;
import org.eclipse.xtext.ide.editor.folding.FoldingRangeKind;
import org.eclipse.xtext.ide.editor.folding.IFoldingRangeAcceptor;
import org.eclipse.xtext.ide.editor.folding.IFoldingRangeProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.LineAndColumn;
import org.eclipse.xtext.util.TextRegion;

public class DefaultFoldingRangeProvider
implements IFoldingRangeProvider {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName")
    private String ruleName = "ML_COMMENT";
    protected static final Pattern TEXT_PATTERN_IN_COMMENT = Pattern.compile("\\w");

    @Override
    public SortedSet<FoldingRange> getFoldingRanges(XtextResource xtextDocument, CancelIndicator cancelIndicator) {
        TreeSet<FoldingRange> result = new TreeSet<FoldingRange>((a, b) -> Integer.compare(a.getOffset(), b.getOffset()));
        IFoldingRangeAcceptor foldingRegionAcceptor = this.createAcceptor(xtextDocument, result);
        this.computeObjectFolding(xtextDocument, foldingRegionAcceptor, cancelIndicator);
        this.computeCommentFolding(xtextDocument, foldingRegionAcceptor);
        return result;
    }

    protected void computeObjectFolding(XtextResource resource, IFoldingRangeAcceptor foldingRangeAcceptor, CancelIndicator cancelIndicator) {
        EObject rootASTElement;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null) {
            if (cancelIndicator.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.isHandled(rootASTElement)) {
                this.acceptObjectFolding(rootASTElement, foldingRangeAcceptor);
            }
            if (this.shouldProcessContent(rootASTElement)) {
                TreeIterator allContents = rootASTElement.eAllContents();
                while (allContents.hasNext()) {
                    if (cancelIndicator.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    EObject eObject = (EObject)allContents.next();
                    if (this.isHandled(eObject)) {
                        this.acceptObjectFolding(eObject, foldingRangeAcceptor);
                    }
                    if (this.shouldProcessContent(eObject)) continue;
                    allContents.prune();
                }
            }
        }
    }

    protected void acceptObjectFolding(EObject eObject, IFoldingRangeAcceptor foldingRangeAcceptor) {
        ITextRegion region = this.locationInFileProvider.getFullTextRegion(eObject);
        if (region != null) {
            ICompositeNode eObjectNode = NodeModelUtils.getNode((EObject)eObject);
            ITextRegion significant = this.buildSignificantRegion(this.locationInFileProvider.getSignificantTextRegion(eObject), (INode)eObjectNode);
            foldingRangeAcceptor.accept(region.getOffset(), region.getLength(), null, false, significant);
        }
    }

    protected ITextRegion buildSignificantRegion(ITextRegion significantRegion, INode node) {
        int endLine;
        int startLine;
        if (significantRegion == null || node == null) {
            return null;
        }
        int offset = significantRegion.getOffset();
        int endOffset = significantRegion.getOffset() + significantRegion.getLength();
        if (significantRegion instanceof ITextRegionWithLineInformation) {
            ITextRegionWithLineInformation lineInfoRegion = (ITextRegionWithLineInformation)significantRegion;
            startLine = lineInfoRegion.getLineNumber();
            endLine = lineInfoRegion.getEndLineNumber();
        } else {
            startLine = NodeModelUtils.getLineAndColumn((INode)node, (int)offset).getLine();
            endLine = NodeModelUtils.getLineAndColumn((INode)node, (int)endOffset).getLine();
        }
        if (startLine != endLine) {
            for (int index = offset; index < endOffset; ++index) {
                LineAndColumn lineInfo = NodeModelUtils.getLineAndColumn((INode)node, (int)index);
                if (lineInfo.getLine() == startLine) continue;
                return new TextRegion(offset, index - offset - 1);
            }
        }
        return significantRegion;
    }

    protected void computeCommentFolding(XtextResource resource, IFoldingRangeAcceptor foldingRangeAcceptor) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            EObject rootASTElement = parseResult.getRootASTElement();
            this.acceptCommentNodes(rootASTElement, foldingRangeAcceptor);
        }
    }

    protected void acceptCommentNodes(EObject eObject, IFoldingRangeAcceptor foldingRangeAcceptor) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            for (INode leafNode : node.getAsTreeIterable()) {
                if (!(leafNode.getGrammarElement() instanceof TerminalRule) || !this.ruleName.equalsIgnoreCase(((TerminalRule)leafNode.getGrammarElement()).getName())) continue;
                this.acceptCommentFolding(leafNode, foldingRangeAcceptor);
            }
        }
    }

    protected void acceptCommentFolding(INode commentNode, IFoldingRangeAcceptor foldingRangeAcceptor) {
        int offset = commentNode.getOffset();
        int length = commentNode.getLength();
        Matcher matcher = this.getTextPatternInComment().matcher(commentNode.getText());
        if (matcher.find()) {
            TextRegion significant = new TextRegion(offset + matcher.start(), 0);
            foldingRangeAcceptor.accept(offset, length, FoldingRangeKind.COMMENT, (ITextRegion)significant);
        } else {
            foldingRangeAcceptor.accept(offset, length, FoldingRangeKind.COMMENT);
        }
    }

    protected IFoldingRangeAcceptor createAcceptor(XtextResource resource, Collection<FoldingRange> foldingRanges) {
        return new DefaultFoldingRangeAcceptor(foldingRanges);
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }

    protected String getMultilineCommentRuleName() {
        return this.ruleName;
    }

    protected Pattern getTextPatternInComment() {
        return TEXT_PATTERN_IN_COMMENT;
    }

    protected boolean isHandled(EObject eObject) {
        return eObject.eContainer() != null;
    }

    protected boolean shouldProcessContent(EObject object) {
        return true;
    }
}

