/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.xtext.util.DisposableRegistry;
import org.eclipse.xtext.util.IDisposable;

@Singleton
public class ExecutorServiceProvider
implements Provider<ExecutorService>,
IDisposable {
    private final Map<String, ExecutorService> instanceCache = Maps.newHashMapWithExpectedSize((int)3);

    @Inject
    public void registerTo(DisposableRegistry disposableRegistry) {
        disposableRegistry.register((IDisposable)this);
    }

    public ExecutorService get() {
        return this.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService get(String key) {
        ExecutorService result = this.instanceCache.get(key);
        if (result == null) {
            Map<String, ExecutorService> map = this.instanceCache;
            synchronized (map) {
                result = this.instanceCache.get(key);
                if (result == null) {
                    result = this.createInstance(key);
                    this.instanceCache.put(key, result);
                }
            }
        }
        return result;
    }

    protected ExecutorService createInstance(String key) {
        return Executors.newCachedThreadPool();
    }

    public void dispose() {
        for (ExecutorService executorService : this.instanceCache.values()) {
            executorService.shutdown();
        }
        this.instanceCache.clear();
    }
}

