/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.ReadRequest;
import org.eclipse.xtext.ide.server.concurrent.WriteRequest;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class RequestManager {
    @Inject
    private ExecutorService parallel;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final ExecutorService queue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RequestManager-Queue-%d").build());
    private List<AbstractRequest<?>> requests = new ArrayList();

    public void shutdown() {
        this.queue.shutdown();
        this.parallel.shutdown();
        this.cancel();
    }

    public <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> cancellable) {
        return this.submit(new ReadRequest<V>(this, cancellable, this.parallel));
    }

    public <U, V> CompletableFuture<V> runWrite(Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable) {
        return this.submit(new WriteRequest<U, V>(this, nonCancellable, cancellable, this.cancel()));
    }

    protected <V> CompletableFuture<V> submit(AbstractRequest<V> request) {
        this.requests.add(request);
        this.queue.submit(request);
        return request.get();
    }

    protected CompletableFuture<Void> cancel() {
        List<AbstractRequest<?>> localRequests = this.requests;
        this.requests = new ArrayList();
        CompletableFuture[] cfs = new CompletableFuture[localRequests.size()];
        int max = localRequests.size();
        for (int i = 0; i < max; ++i) {
            AbstractRequest<?> request = localRequests.get(i);
            request.cancel();
            cfs[i] = request.get();
        }
        return CompletableFuture.allOf(cfs);
    }

    protected boolean isCancelException(Throwable t) {
        if (t == null) {
            return false;
        }
        Throwable cause = t;
        if (t instanceof CompletionException) {
            cause = ((CompletionException)t).getCause();
        }
        return this.operationCanceledManager.isOperationCanceledException(cause);
    }
}

