/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Log
public class SocketServerLauncher {
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final String TRACE = "-trace";
    public static final String NO_VALIDATE = "-noValidate";
    public static final int DEFAULT_PORT = 5008;
    public static final String DEFAULT_HOST = "0.0.0.0";
    private static final Logger LOG = Logger.getLogger(SocketServerLauncher.class);

    public static void main(String[] args) {
        new SocketServerLauncher().launch(args);
    }

    public void launch(String[] args) {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{this.getServerModule()});
            AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(this.getSocketAddress(args));
            InetSocketAddress _socketAddress = this.getSocketAddress(args);
            String _plus = "Started server socket at " + _socketAddress;
            LOG.info((Object)_plus);
            while (true) {
                AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                PrintWriter trace = this.getTrace(args);
                boolean validate = this.shouldValidate(args);
                LanguageServerImpl languageServer = (LanguageServerImpl)injector.getInstance(LanguageServerImpl.class);
                SocketAddress _remoteAddress = socketChannel.getRemoteAddress();
                String _plus_1 = "Starting Xtext Language Server for client " + _remoteAddress;
                LOG.info((Object)_plus_1);
                Launcher launcher = Launcher.createLauncher((Object)languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (boolean)validate, (PrintWriter)trace);
                languageServer.connect((LanguageClient)launcher.getRemoteProxy());
                launcher.startListening();
                LOG.info((Object)"Xtext Language Server has been started.");
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof Throwable)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Throwable throwable = _t;
            throwable.printStackTrace();
            return;
        }
    }

    protected Module getServerModule() {
        return new ServerModule();
    }

    protected PrintWriter getTrace(String ... args) {
        PrintWriter _xifexpression = null;
        boolean _contains = ((List)Conversions.doWrapArray((Object)args)).contains(TRACE);
        if (_contains) {
            _xifexpression = new PrintWriter(System.out);
        }
        return _xifexpression;
    }

    protected boolean shouldValidate(String ... args) {
        boolean _contains = ((List)Conversions.doWrapArray((Object)args)).contains(NO_VALIDATE);
        return !_contains;
    }

    protected InetSocketAddress getSocketAddress(String ... args) {
        String _host = this.getHost(args);
        int _port = this.getPort(args);
        return new InetSocketAddress(_host, _port);
    }

    protected String getHost(String ... args) {
        String _elvis = null;
        String _value = this.getValue(args, HOST);
        _elvis = _value != null ? _value : DEFAULT_HOST;
        return _elvis;
    }

    protected int getPort(String ... args) {
        Integer _elvis = null;
        Integer _integer = Integer.getInteger(this.getValue(args, PORT));
        _elvis = _integer != null ? _integer : Integer.valueOf(5008);
        return _elvis;
    }

    protected String getValue(String[] args, String argName) {
        for (int i = 0; i < args.length - 1; ++i) {
            String _get = args[i];
            boolean _equals = Objects.equal((Object)_get, (Object)argName);
            if (!_equals) continue;
            return args[i + 1];
        }
        return null;
    }
}

