/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ContentAssistService {
    public static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    private IdeContentProposalProvider proposalProvider;
    @Inject
    private Provider<IdeContentProposalAcceptor> proposalAcceptorProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public CompletionList createCompletionList(Document document, XtextResource resource, TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        try {
            CompletionList result = new CompletionList();
            result.setIsIncomplete(true);
            IdeContentProposalAcceptor acceptor = (IdeContentProposalAcceptor)this.proposalAcceptorProvider.get();
            int caretOffset = document.getOffSet(params.getPosition());
            Position caretPosition = params.getPosition();
            TextRegion position = new TextRegion(caretOffset, 0);
            try {
                this.createProposals(document.getContents(), position, caretOffset, resource, acceptor);
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    boolean _not;
                    Throwable t = _t;
                    boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(t);
                    boolean bl = _not = !_isOperationCanceledException;
                    if (_not) {
                        throw t;
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Procedures.Procedure2 _function = (it, idx) -> {
                CompletionItem item = this.toCompletionItem((ContentAssistEntry)it, caretOffset, caretPosition, document);
                item.setSortText(Strings.padStart((String)Integer.toString(idx), (int)5, (char)'0'));
                List _items = result.getItems();
                _items.add(item);
            };
            IterableExtensions.forEach(acceptor.getEntries(), (Procedures.Procedure2)_function);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void createProposals(String document, TextRegion selection, int caretOffset, XtextResource resource, IIdeContentProposalAcceptor acceptor) {
        boolean _greaterThan;
        int _length = document.length();
        boolean bl = _greaterThan = caretOffset > _length;
        if (_greaterThan) {
            return;
        }
        ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        contextFactory.setPool(this.executorService);
        ContentAssistContext[] contexts = contextFactory.create(document, (ITextRegion)selection, caretOffset, resource);
        this.proposalProvider.createProposals((Collection)Conversions.doWrapArray((Object)contexts), acceptor);
    }

    protected CompletionItem toCompletionItem(ContentAssistEntry entry, int caretOffset, Position caretPosition, Document document) {
        boolean _not;
        String _proposal;
        CompletionItem completionItem = new CompletionItem();
        String _elvis = null;
        String _label = entry.getLabel();
        _elvis = _label != null ? _label : (_proposal = entry.getProposal());
        completionItem.setLabel(_elvis);
        completionItem.setDetail(entry.getDescription());
        completionItem.setDocumentation(entry.getDocumentation());
        String _elvis_1 = null;
        String _prefix = entry.getPrefix();
        _elvis_1 = _prefix != null ? _prefix : "";
        int _length = _elvis_1.length();
        int prefixOffset = caretOffset - _length;
        Position prefixPosition = document.getPosition(prefixOffset);
        Range _range = new Range(prefixPosition, caretPosition);
        String _proposal_1 = entry.getProposal();
        TextEdit _textEdit = new TextEdit(_range, _proposal_1);
        completionItem.setTextEdit(_textEdit);
        completionItem.setKind(this.translateKind(entry));
        boolean _isEmpty = entry.getTextReplacements().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _tripleEquals;
            List _additionalTextEdits = completionItem.getAdditionalTextEdits();
            boolean bl2 = _tripleEquals = _additionalTextEdits == null;
            if (_tripleEquals) {
                int _size = entry.getTextReplacements().size();
                ArrayList _arrayList = new ArrayList(_size);
                completionItem.setAdditionalTextEdits(_arrayList);
            }
            Consumer<ReplaceRegion> _function = it -> {
                List _additionalTextEdits_1 = completionItem.getAdditionalTextEdits();
                TextEdit _textEdit_1 = this.toTextEdit((ReplaceRegion)it, document);
                _additionalTextEdits_1.add(_textEdit_1);
            };
            entry.getTextReplacements().forEach(_function);
        }
        return completionItem;
    }

    protected CompletionItemKind translateKind(ContentAssistEntry entry) {
        CompletionItemKind _switchResult = null;
        String _kind = entry.getKind();
        if (_kind != null) {
            switch (_kind) {
                case "CLASS": {
                    _switchResult = CompletionItemKind.Class;
                    break;
                }
                case "COLOR": {
                    _switchResult = CompletionItemKind.Color;
                    break;
                }
                case "CONSTRUCTOR": {
                    _switchResult = CompletionItemKind.Constructor;
                    break;
                }
                case "ENUM": {
                    _switchResult = CompletionItemKind.Enum;
                    break;
                }
                case "FIELD": {
                    _switchResult = CompletionItemKind.Field;
                    break;
                }
                case "FILE": {
                    _switchResult = CompletionItemKind.File;
                    break;
                }
                case "FUNCTION": {
                    _switchResult = CompletionItemKind.Function;
                    break;
                }
                case "INTERFACE": {
                    _switchResult = CompletionItemKind.Interface;
                    break;
                }
                case "KEYWORD": {
                    _switchResult = CompletionItemKind.Keyword;
                    break;
                }
                case "METHOD": {
                    _switchResult = CompletionItemKind.Method;
                    break;
                }
                case "MODULE": {
                    _switchResult = CompletionItemKind.Module;
                    break;
                }
                case "PROPERTY": {
                    _switchResult = CompletionItemKind.Property;
                    break;
                }
                case "REFERENCE": {
                    _switchResult = CompletionItemKind.Reference;
                    break;
                }
                case "SNIPPET": {
                    _switchResult = CompletionItemKind.Snippet;
                    break;
                }
                case "TEXT": {
                    _switchResult = CompletionItemKind.Text;
                    break;
                }
                case "UNIT": {
                    _switchResult = CompletionItemKind.Unit;
                    break;
                }
                case "VALUE": {
                    _switchResult = CompletionItemKind.Value;
                    break;
                }
                case "VARIABLE": {
                    _switchResult = CompletionItemKind.Variable;
                    break;
                }
                default: {
                    _switchResult = CompletionItemKind.Value;
                    break;
                }
            }
        } else {
            _switchResult = CompletionItemKind.Value;
        }
        return _switchResult;
    }

    protected TextEdit toTextEdit(ReplaceRegion region, Document doc) {
        boolean _greaterThan_1;
        int _length;
        boolean _greaterThan;
        TextEdit _xblockexpression = null;
        Position _xifexpression = null;
        int _offset = region.getOffset();
        boolean bl = _greaterThan = _offset > (_length = doc.getContents().length());
        if (_greaterThan) {
            Position _xblockexpression_1 = null;
            Position docEnd = doc.getPosition(doc.getContents().length());
            int _line = docEnd.getLine();
            int _character = docEnd.getCharacter();
            int _length_1 = region.getLength();
            int _plus = _character + _length_1;
            _xifexpression = _xblockexpression_1 = new Position(_line, _plus);
        } else {
            _xifexpression = doc.getPosition(region.getOffset());
        }
        Position start = _xifexpression;
        Position _xifexpression_1 = null;
        int _endOffset = region.getEndOffset();
        int _length_1 = doc.getContents().length();
        boolean bl2 = _greaterThan_1 = _endOffset > _length_1;
        if (_greaterThan_1) {
            int _line = start.getLine();
            int _character = start.getCharacter();
            int _length_2 = region.getLength();
            int _plus = _character + _length_2;
            _xifexpression_1 = new Position(_line, _plus);
        } else {
            _xifexpression_1 = doc.getPosition(region.getEndOffset());
        }
        Position end = _xifexpression_1;
        Range _range = new Range(start, end);
        String _text = region.getText();
        _xblockexpression = new TextEdit(_range, _text);
        return _xblockexpression;
    }
}

