/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.regionaccess.IAstRegion;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.impl.ChangeTreeProvider;
import org.eclipse.xtext.ide.serializer.impl.InsertionPointFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.TokenStreamSequenceAdapter;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;
import org.eclipse.xtext.util.EmfFormatter;

public class PartialSerializer {
    @Inject
    private InsertionPointFinder insertionPointFinder;
    @Inject
    private IGrammarConstraintProvider constraintProvider;
    @Inject
    private IContextFinder contextFinder;
    @Inject
    private ICrossReferenceSerializer crossRefSerializer;
    private ISerializationDiagnostic.Acceptor errorAcceptor = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
    @Inject
    private IGrammarAccess grammar;
    @Inject
    private Provider<IHiddenTokenSequencer> hiddenTokenSequencerProvider;
    @Inject
    private Provider<ISemanticSequencer> semanticSequencerProvider;
    @Inject
    @Named(value="languageName")
    private String serializerLanguage;
    @Inject
    private Provider<ISyntacticSequencer> syntacticSequencerProvider;
    @Inject
    private ITransientValueService transientValues;
    @Inject
    private IValueSerializer valueSerializer;

    protected void assertLanguage(ChangeTreeProvider.ResourceRecording change) {
        String resourceLanguage;
        Resource resource = change.getResource();
        if (resource instanceof XtextResource && !this.serializerLanguage.equals(resourceLanguage = ((XtextResource)resource).getLanguageName())) {
            throw new IllegalArgumentException("Can't use serializer from language " + this.serializerLanguage + " to serialize a resource from language " + resourceLanguage + ".");
        }
    }

    protected List<ChangeTreeProvider.EObjectChange> collectRootChanges(Collection<? extends ChangeTreeProvider.EObjectChange> roots) {
        ArrayList result = Lists.newArrayList();
        LinkedList<? extends ChangeTreeProvider.EObjectChange> stack = new LinkedList<ChangeTreeProvider.EObjectChange>();
        stack.addAll(roots);
        while (!stack.isEmpty()) {
            ChangeTreeProvider.EObjectChange candidate = (ChangeTreeProvider.EObjectChange)stack.pop();
            if (candidate.getChanges().isEmpty()) {
                stack.addAll(candidate.getChildren());
                continue;
            }
            result.add(candidate);
        }
        return result;
    }

    public ISerializationDiagnostic.Acceptor getErrorAcceptor() {
        return this.errorAcceptor;
    }

    protected ISerializationContext getSerializationContext(EObject semanticObject) {
        Iterator contexts = this.contextFinder.findByContentsAndContainer(semanticObject, null).iterator();
        if (!contexts.hasNext()) {
            throw new RuntimeException("No Context for " + EmfFormatter.objPath((EObject)semanticObject) + " could be found");
        }
        return (ISerializationContext)contexts.next();
    }

    protected ISerializationContext getSerializationContext(IEObjectRegion region) {
        EObject grammarElement = region.getGrammarElement();
        if (grammarElement instanceof RuleCall) {
            grammarElement = ((RuleCall)grammarElement).getRule();
        }
        return SerializationContext.fromEObject((EObject)grammarElement, (EObject)region.getSemanticElement());
    }

    public void serializeChanges(ChangeTreeProvider.ResourceRecording changes, ITextRegionDiffBuilder result) {
        this.assertLanguage(changes);
        SerializationContextMap constraints = this.constraintProvider.getConstraints(this.grammar.getGrammar());
        List<ChangeTreeProvider.EObjectChange> rootChanges = this.collectRootChanges(changes.getRootEObjectRecordings());
        ArrayList strategies = Lists.newArrayList();
        for (ChangeTreeProvider.EObjectChange change : rootChanges) {
            List<SerializationStrategy> strat = this.trySerializeEObject(change, result, (SerializationContextMap<IGrammarConstraintProvider.IConstraint>)constraints);
            if (strat == null) continue;
            strategies.addAll(strat);
        }
        for (SerializationStrategy strategy : strategies) {
            strategy.serialize(result);
        }
    }

    protected List<SerializationStrategy> trySerializeEObject(ChangeTreeProvider.EObjectChange change, ITextRegionDiffBuilder result, SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints) {
        ArrayList strategies = Lists.newArrayList();
        EObject obj = change.getEObject();
        IEObjectRegion originalEObjectRegion = result.getOriginalTextRegionAccess().regionForEObject(obj);
        ISerializationContext modified = this.getSerializationContext(obj);
        if (originalEObjectRegion == null) {
            return null;
        }
        ISerializationContext original = this.getSerializationContext(originalEObjectRegion);
        if (!original.equals(modified)) {
            strategies.add(new SerializeRecursiveStrategy((ISequentialRegion)originalEObjectRegion, obj, modified));
            return strategies;
        }
        IGrammarConstraintProvider.IConstraint constraint = (IGrammarConstraintProvider.IConstraint)constraints.get(modified);
        List<SerializationStrategy> features = this.trySerializeIndividualFeatures(change, originalEObjectRegion, modified, constraint);
        if (features == null) {
            strategies.add(new SerializeRecursiveStrategy((ISequentialRegion)originalEObjectRegion, obj, modified));
            return strategies;
        }
        strategies.addAll(features);
        for (ChangeTreeProvider.EObjectChange child : change.getChildren()) {
            List<SerializationStrategy> c = this.trySerializeEObject(child, result, constraints);
            if (c == null) {
                return Collections.singletonList(new SerializeRecursiveStrategy((ISequentialRegion)originalEObjectRegion, obj, modified));
            }
            strategies.addAll(c);
        }
        return strategies;
    }

    public void setErrorAcceptor(ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.errorAcceptor = errorAcceptor;
    }

    protected List<SerializationStrategy> trySerializeIndividualFeatures(ChangeTreeProvider.EObjectChange change, IEObjectRegion original, ISerializationContext context, IGrammarConstraintProvider.IConstraint constraint) {
        ArrayList result = Lists.newArrayList();
        EObject object = change.getEObject();
        for (FeatureChange featureChange : change.getChanges()) {
            EStructuralFeature feature = featureChange.getFeature();
            List<SerializationStrategy> values = null;
            values = feature.isMany() ? this.trySerializeMultiValue(object, featureChange, original, constraint) : this.trySerializeSingleValue(object, featureChange, original, constraint);
            if (values == null) {
                return null;
            }
            result.addAll(values);
        }
        return result;
    }

    protected List<SerializationStrategy> trySerializeSingleValue(EObject owner, FeatureChange change, IEObjectRegion ownerRegion, IGrammarConstraintProvider.IConstraint constraint) {
        ArrayList result = Lists.newArrayList();
        EStructuralFeature feature = change.getFeature();
        IGrammarConstraintProvider.IFeatureInfo featureInfo = constraint.getFeatures()[owner.eClass().getFeatureID(feature)];
        List assignments = featureInfo.getAssignments();
        if (assignments.size() != 1) {
            return null;
        }
        boolean optional = ((IGrammarConstraintProvider.IConstraintElement)assignments.get(0)).isOptional();
        IAstRegion featureRegion = this.findRegion(ownerRegion, change);
        ITransientValueService.ValueTransient valueTransient = this.transientValues.isValueTransient(owner, feature);
        switch (valueTransient) {
            case YES: {
                if (featureRegion == null) break;
                if (optional) {
                    result.add(new DeleteRegionStrategy(featureRegion));
                    break;
                }
                return null;
            }
            case PREFERABLY: {
                if (featureRegion == null) break;
                if (optional) {
                    result.add(new DeleteRegionStrategy(featureRegion));
                    break;
                }
                SerializationStrategy update = this.updateSingleValue(owner, feature, featureRegion);
                if (update != null) {
                    result.add(update);
                    break;
                }
                return null;
            }
            case NO: {
                if (featureRegion == null) {
                    return null;
                }
                SerializationStrategy update = this.updateSingleValue(owner, feature, featureRegion);
                if (update != null) {
                    result.add(update);
                    break;
                }
                return null;
            }
        }
        return result;
    }

    protected List<IAstRegion> findRegions(IEObjectRegion owner, FeatureChange change) {
        EStructuralFeature feature = change.getFeature();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            ITextRegionAccess access = owner.getTextRegionAccess();
            HashSet children = Sets.newHashSet();
            for (ListChange lc : change.getListChanges()) {
                children.addAll(lc.getReferenceValues());
            }
            for (Object obj : (List)owner.getSemanticElement().eGet(feature)) {
                children.add((EObject)obj);
            }
            ArrayList result = Lists.newArrayList();
            for (EObject obj : children) {
                IEObjectRegion region = access.regionForEObject(obj);
                if (region == null) continue;
                result.add(region);
            }
            Collections.sort(result, (a, b) -> a.getOffset() - b.getOffset());
            return ImmutableList.copyOf((Collection)result);
        }
        return ImmutableList.copyOf((Collection)owner.getRegionFor().features(new EStructuralFeature[]{feature}));
    }

    protected IAstRegion findRegion(IEObjectRegion owner, FeatureChange change) {
        EStructuralFeature feature = change.getFeature();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            ITextRegionAccess access = owner.getTextRegionAccess();
            EObject oldValue = change.getReferenceValue();
            if (oldValue != null) {
                return access.regionForEObject(oldValue);
            }
            EObject value = (EObject)owner.getSemanticElement().eGet(feature);
            if (value != null) {
                return access.regionForEObject(value);
            }
            return null;
        }
        return owner.getRegionFor().feature(feature);
    }

    protected List<SerializationStrategy> trySerializeMultiValue(EObject owner, FeatureChange change, IEObjectRegion ownerRegion, IGrammarConstraintProvider.IConstraint constraint) {
        EStructuralFeature feature = change.getFeature();
        ArrayList result = Lists.newArrayList();
        IGrammarConstraintProvider.IFeatureInfo featureInfo = constraint.getFeatures()[owner.eClass().getFeatureID(feature)];
        List assignments = featureInfo.getAssignments();
        if (assignments.size() != 1) {
            return null;
        }
        IGrammarConstraintProvider.IConstraintElement assignment = (IGrammarConstraintProvider.IConstraintElement)assignments.get(0);
        if (!assignment.isMany()) {
            return null;
        }
        List<IAstRegion> originals = this.findRegions(ownerRegion, change);
        EList listChanges = change.getListChanges();
        if (listChanges.isEmpty() && originals.isEmpty()) {
            AbstractElement ins;
            ISerializationContext ctx = this.getSerializationContext(owner);
            IHiddenRegion insertAt = this.insertionPointFinder.findInsertionPoint(ctx, ownerRegion, ins = assignment.getGrammarElement());
            if (insertAt == null) {
                return null;
            }
            for (Object value : (List)owner.eGet(feature)) {
                EObject obj = (EObject)value;
                ISerializationContext context = this.getSerializationContext(obj);
                result.add(new SerializeRecursiveStrategy((ISequentialRegion)insertAt, obj, context));
            }
            return result;
        }
        ArrayList modifying = Lists.newArrayList((Iterable)((List)owner.eGet(feature)));
        for (ListChange lc : listChanges) {
            ChangeKind kind = lc.getKind();
            if (kind == ChangeKind.ADD_LITERAL) {
                IAstRegion region = originals.get(lc.getIndex());
                result.add(new DeleteRegionStrategy(region));
                continue;
            }
            if (kind != ChangeKind.MOVE_LITERAL && kind != ChangeKind.REMOVE_LITERAL) continue;
            if (originals.isEmpty()) {
                return null;
            }
            int index = lc.getIndex();
            IHiddenRegion insertAt = index >= originals.size() ? ((ISequentialRegion)originals.get(originals.size() - 1)).getNextHiddenRegion() : ((ISequentialRegion)originals.get(index)).getPreviousHiddenRegion();
            if (insertAt == null) {
                return null;
            }
            EObject value = (EObject)modifying.get(index);
            modifying.remove(index);
            if (kind == ChangeKind.REMOVE_LITERAL) {
                ISerializationContext context = this.getSerializationContext(value);
                result.add(new SerializeRecursiveStrategy((ISequentialRegion)insertAt, value, context));
                continue;
            }
            if (kind != ChangeKind.MOVE_LITERAL) continue;
            int moveToIndex = lc.getMoveToIndex();
            IAstRegion source = originals.get(moveToIndex);
            result.add(new DeleteRegionStrategy(source));
            result.add(new InsertRegionStrategy(insertAt, source));
        }
        return result;
    }

    protected SerializationStrategy updateSingleValue(EObject object, EStructuralFeature feature, IAstRegion region) {
        Preconditions.checkArgument((!feature.isMany() ? 1 : 0) != 0);
        Object value = object.eGet(feature);
        EObject grammarElement = region.getGrammarElement();
        if (feature instanceof EAttribute) {
            RuleCall rc;
            String newValue;
            if (grammarElement instanceof RuleCall && (newValue = this.valueSerializer.serializeAssignedValue(object, rc = (RuleCall)grammarElement, value, null, this.errorAcceptor)) != null) {
                return new ReplaceRegionStrategy((ISemanticRegion)region, newValue);
            }
            return null;
        }
        if (feature instanceof EReference) {
            EObject target;
            String newValue;
            if (((EReference)feature).isContainment()) {
                IEObjectRegion reg = (IEObjectRegion)region;
                EObject newEObject = (EObject)object.eGet(feature);
                ISerializationContext newContext = this.getSerializationContext(newEObject);
                ISerializationContext oldContext = this.getSerializationContext(reg);
                if (!oldContext.equals(newContext)) {
                    return null;
                }
                return new SerializeRecursiveStrategy((ISequentialRegion)reg, newEObject, newContext);
            }
            CrossReference cr = GrammarUtil.containingCrossReference((EObject)grammarElement);
            if (cr != null && (newValue = this.crossRefSerializer.serializeCrossRef(object, cr, target = (EObject)value, null, this.errorAcceptor)) != null) {
                return new ReplaceRegionStrategy((ISemanticRegion)region, newValue);
            }
            return null;
        }
        return null;
    }

    protected class SerializeRecursiveStrategy
    implements SerializationStrategy {
        private final ISerializationContext context;
        private final EObject root;
        private final ISequentialRegion insertAt;

        public SerializeRecursiveStrategy(ISequentialRegion insertAt, EObject root, ISerializationContext context) {
            Preconditions.checkNotNull((Object)insertAt);
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)root);
            this.insertAt = insertAt;
            this.context = context;
            this.root = root;
        }

        @Override
        public void serialize(ITextRegionDiffBuilder result) {
            ISequenceAcceptor acceptor;
            ISemanticSequencer semantic = (ISemanticSequencer)PartialSerializer.this.semanticSequencerProvider.get();
            ISyntacticSequencer syntactic = (ISyntacticSequencer)PartialSerializer.this.syntacticSequencerProvider.get();
            IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)PartialSerializer.this.hiddenTokenSequencerProvider.get();
            semantic.init((ISemanticSequenceAcceptor)syntactic, PartialSerializer.this.errorAcceptor);
            syntactic.init(this.context, this.root, (ISyntacticSequenceAcceptor)hidden, PartialSerializer.this.errorAcceptor);
            if (this.insertAt instanceof IHiddenRegion) {
                IHiddenRegion h = (IHiddenRegion)this.insertAt;
                acceptor = result.replaceSequence(h, h, this.context, this.root);
            } else {
                IHiddenRegion originalFirst = this.insertAt.getPreviousHiddenRegion();
                IHiddenRegion originalLast = this.insertAt.getNextHiddenRegion();
                acceptor = result.replaceSequence(originalFirst, originalLast, this.context, this.root);
            }
            hidden.init(this.context, this.root, acceptor, PartialSerializer.this.errorAcceptor);
            if (acceptor instanceof TokenStreamSequenceAdapter) {
                ((TokenStreamSequenceAdapter)acceptor).init(this.context);
            }
            semantic.createSequence(this.context, this.root);
        }
    }

    protected static interface SerializationStrategy {
        public void serialize(ITextRegionDiffBuilder var1);
    }

    protected static class ReplaceRegionStrategy
    implements SerializationStrategy {
        private final String newText;
        private final ISemanticRegion region;

        public ReplaceRegionStrategy(ISemanticRegion region, String newText) {
            this.region = region;
            this.newText = newText;
        }

        @Override
        public void serialize(ITextRegionDiffBuilder result) {
            result.replace(this.region, this.newText);
        }
    }

    protected static class InsertRegionStrategy
    implements SerializationStrategy {
        private final IHiddenRegion insertAt;
        private final ISequentialRegion toInsert;

        public InsertRegionStrategy(IHiddenRegion insertAt, IAstRegion toInsert) {
            this.insertAt = insertAt;
            this.toInsert = toInsert;
        }

        @Override
        public void serialize(ITextRegionDiffBuilder result) {
            result.replace(this.insertAt, this.insertAt, this.toInsert.getPreviousHiddenRegion(), this.toInsert.getNextHiddenRegion());
        }
    }

    protected static class DeleteRegionStrategy
    implements SerializationStrategy {
        private final IAstRegion region;

        public DeleteRegionStrategy(IAstRegion region) {
            this.region = region;
        }

        @Override
        public void serialize(ITextRegionDiffBuilder result) {
            result.remove(this.region.getPreviousHiddenRegion(), this.region.getNextHiddenRegion());
        }
    }
}

