/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.ide.server.rename.ChangeConverter;
import org.eclipse.xtext.ide.server.rename.IRenameService;
import org.eclipse.xtext.ide.server.rename.ServerRefactoringIssueAcceptor;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;

public class RenameService
implements IRenameService {
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    private IRenameStrategy2 renameStrategy;
    @Inject
    private ChangeConverter.Factory converterFactory;
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    private Provider<IChangeSerializer> changeSerializerProvider;
    @Inject
    private Provider<ServerRefactoringIssueAcceptor> issueProvider;

    @Override
    public WorkspaceEdit rename(WorkspaceManager workspaceManager, RenameParams renameParams, CancelIndicator cancelIndicator) {
        WorkspaceEdit _xblockexpression = null;
        URI uri = this._uriExtensions.toUri(renameParams.getTextDocument().getUri());
        ServerRefactoringIssueAcceptor issueAcceptor = (ServerRefactoringIssueAcceptor)this.issueProvider.get();
        Functions.Function2 _function = (document, resource) -> {
            ProjectManager projectManager = workspaceManager.getProjectManager(uri);
            XtextResourceSet resourceSet = projectManager.createNewResourceSet(projectManager.getIndexState().getResourceDescriptions());
            int offset = document.getOffSet(renameParams.getPosition());
            WorkspaceEdit workspaceEdit = new WorkspaceEdit();
            Resource xtextResource = resourceSet.getResource(resource.getURI(), true);
            if (xtextResource instanceof XtextResource) {
                EObject element = this._eObjectAtOffsetHelper.resolveElementAt((XtextResource)xtextResource, offset);
                if (element == null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("No element found at position line:");
                    int _line = renameParams.getPosition().getLine();
                    _builder.append((Object)_line);
                    _builder.append(" column:");
                    int _character = renameParams.getPosition().getCharacter();
                    _builder.append((Object)_character);
                    issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
                }
                String _newName = renameParams.getNewName();
                URI _uRI = EcoreUtil.getURI((EObject)element);
                RenameChange change = new RenameChange(_newName, _uRI);
                IChangeSerializer changeSerializer = (IChangeSerializer)this.changeSerializerProvider.get();
                RenameContext context = new RenameContext(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RenameChange[]{change})), (ResourceSet)resourceSet, changeSerializer, issueAcceptor);
                this.renameStrategy.applyRename(context);
                ChangeConverter changeConverter = this.converterFactory.create(workspaceManager, workspaceEdit);
                changeSerializer.applyModifications(changeConverter);
            } else {
                issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, "Loaded resource is not an XtextResource", resource.getURI());
            }
            return workspaceEdit;
        };
        _xblockexpression = (WorkspaceEdit)workspaceManager.doRead(uri, _function);
        return _xblockexpression;
    }
}

