/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegmentDiff;
import org.eclipse.xtext.util.ITextRegion;

public class RegionDiffFormatter {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter;
    @Inject
    private Provider<FormatterRequest> formatterRequest;
    @Inject
    private Provider<NullFormatter> nullFormatter;

    protected Collection<ITextRegion> collectRegionsToFormat(ITextRegionAccessDiff regions) {
        ArrayList result = Lists.newArrayList();
        for (ITextSegmentDiff diff : regions.getRegionDifferences()) {
            int offset = diff.getModifiedFirstRegion().getOffset();
            int length = diff.getModifiedLastRegion().getEndOffset() - offset;
            ITextSegment region = regions.regionForOffset(offset, length);
            result.add(region);
        }
        return result;
    }

    protected FormatterRequest createFormatterRequest(ITextRegionAccess rewritten) {
        FormatterRequest request = (FormatterRequest)this.formatterRequest.get();
        request.setTextRegionAccess(rewritten);
        return request;
    }

    protected FormatterRequest createFormatterRequest(ITextRegionAccessDiff rewritten) {
        FormatterRequest request = (FormatterRequest)this.formatterRequest.get();
        request.setTextRegionAccess((ITextRegionAccess)rewritten);
        request.setRegions(this.collectRegionsToFormat(rewritten));
        return request;
    }

    public List<ITextReplacement> format(ITextRegionAccess regions) {
        IFormatter2 fmt = this.getFormatter();
        if (regions instanceof ITextRegionAccessDiff) {
            ITextRegionAccessDiff diff = (ITextRegionAccessDiff)regions;
            FormatterRequest request = this.createFormatterRequest(diff);
            List replacements = fmt.format(request);
            List<ITextReplacement> merged = this.mergeReplacements(diff, replacements);
            return merged;
        }
        FormatterRequest request = this.createFormatterRequest(regions);
        List replacements = fmt.format(request);
        return replacements;
    }

    protected IFormatter2 getFormatter() {
        if (this.formatter != null) {
            return (IFormatter2)this.formatter.get();
        }
        return (IFormatter2)this.nullFormatter.get();
    }

    protected List<ITextReplacement> mergeReplacements(ITextRegionAccessDiff regions, List<ITextReplacement> rep) {
        ITextRegionRewriter rewriter = regions.getOriginalTextRegionAccess().getRewriter();
        ArrayList result = Lists.newArrayList();
        for (ITextSegmentDiff r : regions.getRegionDifferences()) {
            int originalStart = r.getOriginalFirstRegion().getOffset();
            int originalLength = r.getOriginalLastRegion().getEndOffset() - originalStart;
            int modifiedStart = r.getModifiedFirstRegion().getOffset();
            int modifiedLength = r.getModifiedLastRegion().getEndOffset() - modifiedStart;
            ITextSegment modifiedRegion = regions.regionForOffset(modifiedStart, modifiedLength);
            ArrayList local = Lists.newArrayList();
            for (ITextReplacement re : rep) {
                if (!modifiedRegion.contains((ITextRegion)re)) continue;
                local.add(re);
            }
            String newText = local.isEmpty() ? modifiedRegion.getText() : regions.getRewriter().renderToString(modifiedRegion, (Iterable)local);
            ITextReplacement replacement = rewriter.createReplacement(originalStart, originalLength, newText);
            result.add(replacement);
        }
        return result;
    }

    public static final class NullFormatter
    extends AbstractFormatter2 {
        public void format(Object obj, IFormattableDocument document) {
        }
    }
}

