/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.UpdatableReference;
import org.eclipse.xtext.resource.XtextResource;

public class ReferenceUpdaterContext
implements IReferenceUpdaterContext {
    private final EObjectDescriptionDeltaProvider.Deltas deltas;
    private final ITextRegionDiffBuilder diffBuilder;
    private final List<Runnable> handler = Lists.newArrayList();
    private final List<IUpdatableReference> references = Lists.newArrayList();

    public ReferenceUpdaterContext(EObjectDescriptionDeltaProvider.Deltas deltas, ITextRegionDiffBuilder diffBuilder) {
        this.deltas = deltas;
        this.diffBuilder = diffBuilder;
    }

    @Override
    public EObjectDescriptionDeltaProvider.Deltas getEObjectDescriptionDeltas() {
        return this.deltas;
    }

    protected List<Runnable> getModifications() {
        return this.handler;
    }

    @Override
    public ITextRegionDiffBuilder getModifyableDocument() {
        return this.diffBuilder;
    }

    @Override
    public XtextResource getResource() {
        return this.diffBuilder.getOriginalTextRegionAccess().getResource();
    }

    @Override
    public List<IUpdatableReference> getUpdatableReferences() {
        return this.references;
    }

    @Override
    public void modifyModel(Runnable runnable) {
        this.handler.add(runnable);
    }

    @Override
    public void updateReference(EObject owner, EReference reference) {
        IEObjectRegion objectRegion = this.diffBuilder.getOriginalTextRegionAccess().regionForEObject(owner);
        ISemanticRegion region = objectRegion.getRegionFor().feature((EStructuralFeature)reference);
        EObject target = (EObject)owner.eGet((EStructuralFeature)reference);
        CrossReference crossref = GrammarUtil.containingCrossReference((EObject)region.getGrammarElement());
        this.updateReference(owner, reference, -1, region, target, crossref);
    }

    @Override
    public void updateReference(EObject owner, EReference reference, int index) {
        IEObjectRegion objectRegion = this.diffBuilder.getOriginalTextRegionAccess().regionForEObject(owner);
        List regions = objectRegion.getRegionFor().features(new EStructuralFeature[]{reference});
        ISemanticRegion region = (ISemanticRegion)regions.get(index);
        EObject target = (EObject)((List)owner.eGet((EStructuralFeature)reference)).get(index);
        CrossReference crossref = GrammarUtil.containingCrossReference((EObject)region.getGrammarElement());
        this.updateReference(owner, reference, index, region, target, crossref);
    }

    private void updateReference(EObject owner, EReference reference, int index, ISemanticRegion region, EObject target, CrossReference crossref) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)reference);
        Preconditions.checkArgument((!reference.isContainment() ? 1 : 0) != 0);
        if (region == null || target == null || target.eIsProxy() || crossref == null) {
            return;
        }
        this.references.add(new UpdatableReference(owner, reference, index, target, crossref, region));
    }
}

