/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectDescriptionProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;

public class EObjectDescriptionProvider
implements IEObjectDescriptionProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;

    protected QualifiedName computeSimpleName(Multimap<EObject, IEObjectDescription> descs, IEObjectDescription desc) {
        QualifiedName name = desc.getQualifiedName();
        int segmentCount = name.getSegmentCount();
        if (segmentCount < 2) {
            return name;
        }
        for (EObject container = desc.getEObjectOrProxy().eContainer(); container != null; container = container.eContainer()) {
            Collection candidates = descs.get((Object)container);
            for (IEObjectDescription cand : candidates) {
                QualifiedName candName = cand.getQualifiedName();
                int candCount = candName.getSegmentCount();
                if (candCount >= segmentCount || !name.startsWith(candName)) continue;
                return name.skipFirst(candCount);
            }
        }
        return name;
    }

    @Override
    public Iterable<IEObjectDescription> getEObjectDescriptions(Resource resource) {
        HashMultimap map = HashMultimap.create();
        IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
        for (IEObjectDescription desc : description.getExportedObjects()) {
            EObject object = EcoreUtil.resolve((EObject)desc.getEObjectOrProxy(), (Resource)resource);
            map.put((Object)object, (Object)desc);
        }
        TreeIterator it = EcoreUtil2.eAll((EObject)((EObject)resource.getContents().get(0)));
        while (it.hasNext()) {
            QualifiedName name;
            EObject next = (EObject)it.next();
            if (map.containsKey((Object)next) || (name = this.qualifiedNameProvider.getFullyQualifiedName(next)) == null) continue;
            IEObjectDescription desc = EObjectDescription.create((QualifiedName)name, (EObject)next);
            map.put((Object)next, (Object)desc);
        }
        ArrayList result = Lists.newArrayList();
        for (IEObjectDescription desc : map.values()) {
            QualifiedName name = this.computeSimpleName((Multimap<EObject, IEObjectDescription>)map, desc);
            SimpleNameDescription copy = new SimpleNameDescription(name, desc);
            result.add(copy);
        }
        return result;
    }

    protected static class SimpleNameDescription
    implements IEObjectDescription {
        private final EObject object;
        private final QualifiedName qualifiedName;
        private final QualifiedName simpleName;
        private final Map<String, String> userData;

        public SimpleNameDescription(QualifiedName qName, IEObjectDescription source) {
            this.simpleName = qName;
            this.object = source.getEObjectOrProxy();
            this.qualifiedName = source.getQualifiedName();
            Preconditions.checkArgument((!this.object.eIsProxy() ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)this.simpleName);
            Preconditions.checkNotNull((Object)this.qualifiedName);
            HashMap userData = null;
            for (String key : source.getUserDataKeys()) {
                if (userData == null) {
                    userData = Maps.newHashMapWithExpectedSize((int)2);
                }
                userData.put(key, source.getUserData(key));
            }
            this.userData = userData;
        }

        public EClass getEClass() {
            return this.object.eClass();
        }

        public EObject getEObjectOrProxy() {
            return this.object;
        }

        public URI getEObjectURI() {
            throw new UnsupportedOperationException();
        }

        public QualifiedName getName() {
            return this.simpleName;
        }

        public QualifiedName getQualifiedName() {
            return this.qualifiedName;
        }

        public String getUserData(String key) {
            if (this.userData == null) {
                return null;
            }
            return this.userData.get(key);
        }

        public String[] getUserDataKeys() {
            if (this.userData == null) {
                return new String[0];
            }
            return this.userData.keySet().toArray(new String[this.userData.size()]);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(IEObjectDescription.class.getSimpleName() + " " + this.qualifiedName);
            if (this.simpleName != null && !this.simpleName.equals((Object)this.qualifiedName)) {
                result.append(" name:" + this.simpleName);
            }
            if (this.userData != null && !this.userData.isEmpty()) {
                ArrayList items = Lists.newArrayList();
                for (Map.Entry<String, String> e : this.userData.entrySet()) {
                    items.add(e.getKey() + ": " + e.getValue());
                }
                result.append(" userData=[" + Joiner.on((String)", ").join((Iterable)items) + "]");
            }
            return result.toString();
        }
    }
}

