/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectDescriptionProvider;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.ChangeSerializer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Arrays;

public class EObjectDescriptionDeltaProvider {
    protected Delta createDelta(EObject object, IEObjectSnapshot snapshot, List<IEObjectDescription> descriptions) {
        Delta delta = new Delta(object);
        delta.descriptions = descriptions;
        delta.snapshot = snapshot;
        if (snapshot == null || snapshot.getDescriptions() == null || delta.descriptions == null) {
            return delta;
        }
        if (delta.descriptions.size() != snapshot.getDescriptions().size()) {
            return delta;
        }
        if (delta.snapshot.getDescriptions().size() == 1 && delta.descriptions.size() == 1) {
            if (!this.simpleNameAndUserDataEquals(delta.snapshot.getDescriptions().get(0), (IEObjectDescription)delta.descriptions.get(0))) {
                return delta;
            }
            return null;
        }
        HashSet remaining = Sets.newHashSet(snapshot.getDescriptions());
        block0: for (IEObjectDescription desc : descriptions) {
            Iterator it = remaining.iterator();
            while (it.hasNext()) {
                IEObjectDescription next = (IEObjectDescription)it.next();
                if (!this.simpleNameAndUserDataEquals(desc, next)) continue;
                it.remove();
                continue block0;
            }
            return null;
        }
        if (remaining.isEmpty()) {
            return delta;
        }
        return null;
    }

    public Deltas getDelta(ChangeSerializer serializer, Collection<IResourceSnapshot> snapshots) {
        HashMap old = Maps.newHashMap();
        HashMap groups = Maps.newHashMap();
        for (IResourceSnapshot rs : snapshots) {
            old.putAll(rs.getObjects());
        }
        for (IResourceSnapshot rs : snapshots) {
            IEObjectDescriptionProvider p = serializer.getService(rs.getResource(), IEObjectDescriptionProvider.class);
            Iterable<IEObjectDescription> descriptions = p.getEObjectDescriptions(rs.getResource());
            for (IEObjectDescription desc : descriptions) {
                EObject obj = EcoreUtil.resolve((EObject)desc.getEObjectOrProxy(), (Resource)rs.getResource());
                Group delta = (Group)groups.get(obj);
                if (delta == null) {
                    delta = new Group(obj);
                    delta.snapshot = (IEObjectSnapshot)old.get(obj);
                    groups.put(obj, delta);
                }
                delta.descriptions.add(desc);
            }
        }
        Deltas result = new Deltas();
        result.snapshots = snapshots;
        for (Group g : groups.values()) {
            Delta delta = this.createDelta(g.object, g.snapshot, g.descriptions);
            if (delta == null) continue;
            result.deltas.put(delta.object, delta);
        }
        return result;
    }

    protected boolean simpleNameAndUserDataEquals(IEObjectDescription oldDesc, IEObjectDescription newDesc) {
        if (!oldDesc.getName().equals((Object)newDesc.getName())) {
            return false;
        }
        return this.userDataEuqals(oldDesc, newDesc);
    }

    protected boolean userDataEuqals(IEObjectDescription oldObj, IEObjectDescription newObj) {
        Object[] newKeys;
        String[] oldKeys = oldObj.getUserDataKeys();
        if (oldKeys.length != (newKeys = newObj.getUserDataKeys()).length) {
            return false;
        }
        for (String key : oldKeys) {
            String newValue;
            if (!Arrays.contains((Object[])newKeys, (Object)key)) {
                return false;
            }
            String oldValue = oldObj.getUserData(key);
            if (Objects.equal((Object)oldValue, (Object)(newValue = newObj.getUserData(key)))) continue;
            return false;
        }
        return true;
    }

    public static class Group {
        private List<IEObjectDescription> descriptions = Lists.newArrayList();
        private final EObject object;
        private IEObjectSnapshot snapshot;

        public Group(EObject object) {
            this.object = object;
        }
    }

    public static class Deltas {
        private Collection<IResourceSnapshot> snapshots;
        private final Map<EObject, Delta> deltas = Maps.newLinkedHashMap();

        public Collection<IResourceSnapshot> getSnapshots() {
            return this.snapshots;
        }

        public Delta findContainingDelta(EObject obj) {
            for (EObject current = obj; current != null; current = current.eContainer()) {
                Delta delta = this.deltas.get(current);
                if (delta == null) continue;
                return delta;
            }
            return null;
        }
    }

    public static class Delta {
        private List<IEObjectDescription> descriptions = Lists.newArrayList();
        private final EObject object;
        private IEObjectSnapshot snapshot;

        public Delta(EObject object) {
            this.object = object;
        }

        public List<IEObjectDescription> getDescriptions() {
            return this.descriptions;
        }

        public IEObjectSnapshot getSnapshot() {
            return this.snapshot;
        }

        public EObject getObject() {
            return this.object;
        }
    }
}

