/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.RecordingResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RecordingXtextResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedEmfResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.ide.serializer.impl.RelatedXtextResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.ResourceUpdater;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;

public class ChangeSerializer
implements IChangeSerializer {
    @Inject
    private EObjectDescriptionDeltaProvider deltaProvider;
    @Inject
    private RelatedResourcesProvider relatedResourcesProvider;
    private ResourceSet resourceSet = null;
    private boolean updateCrossReferences = true;
    private boolean updateRelatedFiles = true;
    private Map<Resource, RecordingResourceUpdater> updaters = Maps.newLinkedHashMap();

    @Override
    public void beginRecordChanges(Resource resource) {
        RecordingResourceUpdater updater = this.updaters.get(resource);
        if (updater != null) {
            return;
        }
        if (this.resourceSet == null) {
            this.resourceSet = resource.getResourceSet();
        } else if (resource.getResourceSet() != this.resourceSet) {
            throw new IllegalStateException("Wrong ResourceSet.");
        }
        updater = this.createResourceUpdater(resource);
        this.updaters.put(resource, updater);
    }

    protected RelatedResourceUpdater createResourceUpdater(RelatedResourcesProvider.RelatedResource relatedResource) {
        URI uri = relatedResource.getUri();
        IGrammarAccess grammar = this.getService(uri, IGrammarAccess.class);
        RelatedResourceUpdater updater = grammar != null ? (RelatedResourceUpdater)this.getService(uri, RelatedXtextResourceUpdater.class) : (RelatedResourceUpdater)this.getService(uri, RelatedEmfResourceUpdater.class);
        updater.init(this, this.resourceSet, relatedResource);
        return updater;
    }

    protected RecordingResourceUpdater createResourceUpdater(Resource resource) {
        if (resource instanceof XtextResource) {
            RecordingXtextResourceUpdater updater = this.getService(resource, RecordingXtextResourceUpdater.class);
            updater.beginRecording(this, (XtextResource)resource);
            return updater;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void endRecordChanges(IAcceptor<IEmfResourceChange> changeAcceptor) {
        if (this.updaters.isEmpty()) {
            return;
        }
        List<IResourceSnapshot> snapshots = this.getSnapshots();
        EObjectDescriptionDeltaProvider.Deltas deltas = this.deltaProvider.getDelta(this, snapshots);
        ArrayList updaters = Lists.newArrayList(this.updaters.values());
        if (this.updateRelatedFiles && this.updateCrossReferences) {
            List<RelatedResourcesProvider.RelatedResource> related = this.relatedResourcesProvider.getRelatedResources(deltas.getSnapshots());
            for (RelatedResourcesProvider.RelatedResource ref : related) {
                RelatedResourceUpdater updater = this.createResourceUpdater(ref);
                updaters.add(updater);
            }
        }
        for (ResourceUpdater updater : updaters) {
            updater.applyChange(deltas, changeAcceptor);
        }
        for (ResourceUpdater updater : updaters) {
            updater.unload();
        }
    }

    @Override
    public ITextRegionDiffBuilder getModifyableDocument(Resource resource) {
        RecordingResourceUpdater updater = this.updaters.get(resource);
        if (updater instanceof RecordingXtextResourceUpdater) {
            return ((RecordingXtextResourceUpdater)updater).getDocument();
        }
        return null;
    }

    protected <T> T getService(Resource resource, Class<T> clazz) {
        if (resource instanceof XtextResource) {
            return (T)((XtextResource)resource).getResourceServiceProvider().get(clazz);
        }
        return this.getService(resource.getURI(), clazz);
    }

    protected <T> T getService(URI uri, Class<T> clazz) {
        return (T)IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri).get(clazz);
    }

    protected List<IResourceSnapshot> getSnapshots() {
        return this.updaters.values().stream().map(u -> u.getSnapshot()).collect(Collectors.toList());
    }

    @Override
    public boolean isUpdateCrossReferences() {
        return this.updateCrossReferences;
    }

    @Override
    public boolean isUpdateRelatedFiles() {
        return this.updateRelatedFiles;
    }

    @Override
    public void setUpdateCrossReferences(boolean value) {
        this.updateCrossReferences = value;
    }

    @Override
    public void setUpdateRelatedFiles(boolean value) {
        this.updateRelatedFiles = value;
    }
}

