/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.syntaxcoloring;

import com.google.common.base.Objects;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@ImplementedBy(value=DefaultImpl.class)
public interface IEditorHighlightingConfigurationProvider {
    public String getConfiguration(String var1);

    public static class DefaultImpl
    implements IEditorHighlightingConfigurationProvider {
        @Inject
        private IGrammarAccess grammarAccess;
        @Inject
        private LanguageInfo languageInfo;

        @Override
        public String getConfiguration(String editorName) {
            if (Objects.equal((Object)editorName, (Object)"EclipseChe") || Objects.equal((Object)editorName, (Object)"EclipseOrion")) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("[");
                _builder.newLine();
                _builder.append("  ");
                CharSequence _getStandardPatterns = this.getGetStandardPatterns();
                _builder.append((Object)_getStandardPatterns, "  ");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("match: \"\\\\b(?:");
                Iterable<String> _keywords = this.getKeywords();
                String _join = IterableExtensions.join(_keywords, (CharSequence)"|");
                _builder.append(_join, "    ");
                _builder.append(")\\\\b\", ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("name: \"keyword.");
                String _shortName = this.languageInfo.getShortName();
                _builder.append(_shortName, "    ");
                _builder.append("\" ");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("]");
                _builder.newLine();
                return _builder.toString();
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            return _builder_1.toString();
        }

        public CharSequence getGetStandardPatterns() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{include: \"orion.c-like#comment_singleLine\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.c-like#comment_block\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#string_doubleQuote\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#string_singleQuote\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#doc_block\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#number_decimal\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#number_hex\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#brace_open\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#brace_close\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#bracket_open\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#bracket_close\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#parenthesis_open\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#parenthesis_close\"},");
            _builder.newLine();
            _builder.append("{include: \"orion.lib#operator\"},");
            _builder.newLine();
            return _builder;
        }

        public Iterable<String> getKeywords() {
            Grammar _grammar = this.grammarAccess.getGrammar();
            List _containedKeywords = GrammarUtil.containedKeywords((EObject)_grammar);
            Functions.Function1 _function = it -> {
                String _value = it.getValue();
                char _charAt = _value.charAt(0);
                return Character.isLetter(_charAt);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_containedKeywords, (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> it.getValue();
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
            Set _set = IterableExtensions.toSet((Iterable)_map);
            return IterableExtensions.sort((Iterable)_set);
        }
    }
}

