/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public abstract class AbstractIdeTemplateProposalProvider {
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    protected Variable variable(String name) {
        return new Variable(name);
    }

    protected Cursor cursor() {
        return new Cursor();
    }

    protected void acceptProposal(String name, String description, StringConcatenationClient template, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        this.acceptProposal(name, description, template, context, acceptor, true);
    }

    protected void acceptProposal(String name, String description, StringConcatenationClient template, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, boolean adaptIndentation) {
        ContentAssistEntry entry = this.createProposal(template, context, adaptIndentation);
        boolean _canAcceptProposal = this.canAcceptProposal(entry, context);
        if (_canAcceptProposal) {
            entry.setLabel(name);
            entry.setDescription(description);
            int _defaultPriority = this.proposalPriorities.getDefaultPriority(entry);
            acceptor.accept(entry, _defaultPriority);
        }
    }

    protected boolean canAcceptProposal(ContentAssistEntry entry, ContentAssistContext context) {
        String _proposal = entry.getProposal();
        String _prefix = entry.getPrefix();
        return this.proposalCreator.isValidProposal(_proposal, _prefix, context);
    }

    protected ContentAssistEntry createProposal(StringConcatenationClient template, ContentAssistContext context, boolean adaptIndentation) {
        ContentAssistEntry entry = new ContentAssistEntry();
        String _prefix = context.getPrefix();
        entry.setPrefix(_prefix);
        String _lineDelimiter = this.getLineDelimiter();
        TemplateStringConcatenation stringConcat = new TemplateStringConcatenation(context, entry, _lineDelimiter);
        String _xifexpression = null;
        _xifexpression = adaptIndentation ? this.getIndentation(context) : null;
        String indentation = _xifexpression;
        if (indentation == null) {
            stringConcat.append(template);
        } else {
            stringConcat.append(template, indentation);
        }
        String _string = stringConcat.toString();
        entry.setProposal(_string);
        return entry;
    }

    protected String getLineDelimiter() {
        return StringConcatenation.DEFAULT_LINE_DELIMITER;
    }

    protected String getIndentation(ContentAssistContext context) {
        String text;
        ICompositeNode _rootNode = context.getRootNode();
        String _text = null;
        if (_rootNode != null) {
            _text = _rootNode.getText();
        }
        if ((text = _text) != null && text.length() >= context.getOffset()) {
            int lineStart;
            ITextRegion _replaceRegion = context.getReplaceRegion();
            int indentEnd = lineStart = _replaceRegion.getOffset();
            while (lineStart > 0 && text.charAt(lineStart - 1) != "\n".charAt(0)) {
                char _charAt;
                boolean _isWhitespace;
                boolean _not;
                boolean bl = _not = !(_isWhitespace = Character.isWhitespace(_charAt = text.charAt(--lineStart)));
                if (!_not) continue;
                indentEnd = lineStart;
            }
            return text.substring(lineStart, indentEnd);
        }
        return null;
    }

    protected static class Cursor {
        protected Cursor() {
        }
    }

    private static class TemplateStringConcatenation
    extends StringConcatenation {
        private final ContentAssistContext context;
        private final ContentAssistEntry entry;

        public TemplateStringConcatenation(ContentAssistContext context, ContentAssistEntry entry, String lineDelimiter) {
            super(lineDelimiter);
            this.context = context;
            this.entry = entry;
        }

        protected String getStringRepresentation(Object object) {
            if (object instanceof Variable) {
                String varName = ((Variable)object).name;
                ITextRegion _replaceRegion = this.context.getReplaceRegion();
                int _offset = _replaceRegion.getOffset();
                int _currentOffset = this.getCurrentOffset();
                int offset = _offset + _currentOffset;
                ArrayList<TextRegion> _editPositions = this.entry.getEditPositions();
                int _length = varName.length();
                TextRegion _textRegion = new TextRegion(offset, _length);
                _editPositions.add(_textRegion);
                return varName;
            }
            if (object instanceof Cursor) {
                ITextRegion _replaceRegion_1 = this.context.getReplaceRegion();
                int _offset_1 = _replaceRegion_1.getOffset();
                int _currentOffset_1 = this.getCurrentOffset();
                int offset_1 = _offset_1 + _currentOffset_1;
                this.entry.setEscapePosition(offset_1);
                return null;
            }
            return object.toString();
        }

        protected int getCurrentOffset() {
            int result = 0;
            List _content = this.getContent();
            for (String segment : _content) {
                int _result = result;
                int _length = segment.length();
                result = _result + _length;
            }
            return result;
        }

        public void newLineIfNotEmpty() {
            this.newLine();
        }
    }

    @Data
    protected static class Variable {
        private final String name;

        public Variable(String name) {
            this.name = name;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }
    }
}

