/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.generator.trace.EditorInputBasedFileOpener;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.util.IAcceptor;

public class ClassFileBasedOpenerContributor
extends OppositeFileOpenerContributor {
    private static final Logger LOG = Logger.getLogger(ClassFileBasedOpenerContributor.class);
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    public boolean collectGeneratedFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        if (editor instanceof XtextEditor && editor.getEditorInput() instanceof IClassFileEditorInput) {
            acceptor.accept((Object)this.createEditorOpener(editor.getEditorInput(), "org.eclipse.jdt.ui.ClassFileEditor"));
            return true;
        }
        return false;
    }

    public boolean collectSourceFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        if (!(editor instanceof XtextEditor) && editor.getEditorInput() instanceof IClassFileEditorInput) {
            try {
                IClassFile classFile = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile();
                ITrace trace = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
                Iterator iterator = trace.getAllAssociatedLocations().iterator();
                if (iterator.hasNext()) {
                    ILocationInResource location = (ILocationInResource)iterator.next();
                    String name = location.getAbsoluteResourceURI().trimFragment().lastSegment();
                    IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)name);
                    acceptor.accept((Object)this.createEditorOpener(editor.getEditorInput(), editorDescriptor.getId()));
                    return true;
                }
            }
            catch (PartInitException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected EditorInputBasedFileOpener createEditorOpener(IEditorInput editorInput, String editorId) {
        return new EditorInputBasedFileOpener(editorInput, editorId);
    }
}

