/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.ClusteringConfig;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.incremental.BuildContext;
import org.eclipse.xtext.builder.standalone.incremental.BuildRequest;
import org.eclipse.xtext.builder.standalone.incremental.FilesAndURIs;
import org.eclipse.xtext.builder.standalone.incremental.IndexState;
import org.eclipse.xtext.builder.standalone.incremental.Indexer;
import org.eclipse.xtext.builder.standalone.incremental.Source2GeneratedMapping;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class IncrementalStandaloneBuilder {
    private static final Logger LOG = Logger.getLogger(IncrementalStandaloneBuilder.class);
    @Inject
    private Provider<InternalStatefulIncrementalBuilder> provider;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;

    public IndexState build(BuildRequest request, Map<String, LanguageAccess> languages) {
        return this.build(request, languages, null);
    }

    public IndexState build(BuildRequest request, Map<String, LanguageAccess> languages, final ClusteringConfig clusteringConfig) {
        boolean _notEquals;
        DisabledClusteringPolicy _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)clusteringConfig, null);
        if (_notEquals) {
            DynamicResourceClusteringPolicy _xblockexpression = null;
            LOG.info((Object)"Clustering configured.");
            DynamicResourceClusteringPolicy _dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            Procedures.Procedure1<DynamicResourceClusteringPolicy> _function = new Procedures.Procedure1<DynamicResourceClusteringPolicy>(){

                public void apply(DynamicResourceClusteringPolicy it) {
                    long _minimumFreeMemory = clusteringConfig.getMinimumFreeMemory();
                    long _multiply = _minimumFreeMemory * 1024L;
                    long _multiply_1 = _multiply * 1024L;
                    it.setMinimumFreeMemory(_multiply_1);
                    int _minimumClusterSize = clusteringConfig.getMinimumClusterSize();
                    it.setMinimumClusterSize(_minimumClusterSize);
                    long _minimumPercentFreeMemory = clusteringConfig.getMinimumPercentFreeMemory();
                    it.setMinimumPercentFreeMemory(_minimumPercentFreeMemory);
                }
            };
            _xblockexpression = (DynamicResourceClusteringPolicy)ObjectExtensions.operator_doubleArrow((Object)_dynamicResourceClusteringPolicy, (Procedures.Procedure1)_function);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = new DisabledClusteringPolicy();
        }
        DisabledClusteringPolicy strategy = _xifexpression;
        URI _baseDir = request.getBaseDir();
        File _asFile = FilesAndURIs.asFile(_baseDir);
        File tempDir = new File(_asFile, "xtext-tmp");
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        resourceSet.addLoadOption((Object)"org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", (Object)true);
        BuildContext context = new BuildContext(languages, resourceSet, (IResourceClusteringPolicy)strategy, tempDir);
        InternalStatefulIncrementalBuilder builder = (InternalStatefulIncrementalBuilder)this.provider.get();
        builder.context = context;
        builder.request = request;
        return builder.launch();
    }

    protected static class InternalStatefulIncrementalBuilder {
        @Extension
        @Accessors(value={AccessorType.PROTECTED_SETTER})
        private BuildContext context;
        @Accessors(value={AccessorType.PROTECTED_SETTER})
        private BuildRequest request;
        @Inject
        private Indexer indexer;
        private Map<LanguageAccess, JavaIoFileSystemAccess> configuredFsas = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

        protected InternalStatefulIncrementalBuilder() {
        }

        public IndexState launch() {
            this.initialize();
            this.cleanup();
            IndexState _previousState = this.request.getPreviousState();
            Source2GeneratedMapping _fileMappings = _previousState.getFileMappings();
            final Source2GeneratedMapping newSource2GeneratedMapping = _fileMappings.copy();
            List<URI> _deletedFiles = this.request.getDeletedFiles();
            Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                public void apply(URI it) {
                    Set<URI> _deleteSource = newSource2GeneratedMapping.deleteSource(it);
                    Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                        public void apply(URI it) {
                            LOG.info((Object)("Deleting " + it));
                            File _asFile = FilesAndURIs.asFile(it);
                            _asFile.delete();
                            Procedures.Procedure1<? super URI> _afterDeleteFile = InternalStatefulIncrementalBuilder.this.request.getAfterDeleteFile();
                            _afterDeleteFile.apply((Object)it);
                        }
                    };
                    IterableExtensions.forEach(_deleteSource, (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.forEach(_deletedFiles, (Procedures.Procedure1)_function);
            Indexer.IndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            Set<URI> _affectedResources = result.getAffectedResources();
            Functions.Function1<Resource, Boolean> _function_1 = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource resource) {
                    resource.getContents();
                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                    boolean _validate = InternalStatefulIncrementalBuilder.this.validate(resource);
                    if (_validate) {
                        InternalStatefulIncrementalBuilder.this.generate(resource, InternalStatefulIncrementalBuilder.this.request, newSource2GeneratedMapping);
                        return true;
                    }
                    return false;
                }
            };
            this.context.executeClustered(_affectedResources, _function_1);
            ResourceDescriptionsData _newIndex = result.getNewIndex();
            return new IndexState(_newIndex, newSource2GeneratedMapping);
        }

        protected void initialize() {
            boolean _notEquals;
            String _defaultEncoding = this.request.getDefaultEncoding();
            boolean bl = _notEquals = !Objects.equal((Object)_defaultEncoding, null);
            if (_notEquals) {
                LOG.info((Object)"Setting encoding.");
                Map<String, LanguageAccess> _languages = this.context.getLanguages();
                Collection<LanguageAccess> _values = _languages.values();
                for (LanguageAccess lang : _values) {
                    String _defaultEncoding_1;
                    IEncodingProvider _encodingProvider;
                    IEncodingProvider provider = _encodingProvider = lang.getEncodingProvider();
                    boolean _matched = false;
                    if (!_matched && provider instanceof IEncodingProvider.Runtime) {
                        _matched = true;
                        _defaultEncoding_1 = this.request.getDefaultEncoding();
                        ((IEncodingProvider.Runtime)provider).setDefaultEncoding(_defaultEncoding_1);
                    }
                    if (_matched) continue;
                    _defaultEncoding_1 = this.request.getDefaultEncoding();
                    String _plus = "Couldn't set encoding '" + _defaultEncoding_1;
                    String _plus_1 = String.valueOf(_plus) + "' for provider '";
                    String _plus_2 = String.valueOf(_plus_1) + provider;
                    String _plus_3 = String.valueOf(_plus_2) + "'. Only subclasses of IEncodingProvider.Runtime are supported.";
                    LOG.info((Object)_plus_3);
                }
            }
        }

        protected boolean cleanup() {
            try {
                boolean _xifexpression = false;
                File _tempDir = this.context.getTempDir();
                boolean _exists = _tempDir.exists();
                if (_exists) {
                    boolean _xblockexpression = false;
                    File _tempDir_1 = this.context.getTempDir();
                    String _plus = "Removing temp folder " + _tempDir_1;
                    LOG.info((Object)_plus);
                    File _tempDir_2 = this.context.getTempDir();
                    Files.sweepFolder((File)_tempDir_2);
                    File _tempDir_3 = this.context.getTempDir();
                    _xifexpression = _xblockexpression = _tempDir_3.delete();
                }
                return _xifexpression;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        protected boolean validate(Resource resource) {
            URI _uRI = resource.getURI();
            String _lastSegment = _uRI.lastSegment();
            String _plus = "Starting validation for input: '" + _lastSegment;
            String _plus_1 = String.valueOf(_plus) + "'";
            LOG.info((Object)_plus_1);
            URI _uRI_1 = resource.getURI();
            LanguageAccess _languageAccess = this.context.getLanguageAccess(_uRI_1);
            IResourceValidator resourceValidator = _languageAccess.getResourceValidator();
            List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
            IIssueHandler _issueHandler = this.request.getIssueHandler();
            return _issueHandler.handleIssue(validationResult);
        }

        protected void generate(final Resource resource, final BuildRequest request, final Source2GeneratedMapping newMappings) {
            boolean _matched;
            URI _uRI = resource.getURI();
            String _lastSegment = _uRI.lastSegment();
            String _plus = "Starting generator for input: '" + _lastSegment;
            String _plus_1 = String.valueOf(_plus) + "'";
            LOG.info((Object)_plus_1);
            URI _uRI_1 = resource.getURI();
            LanguageAccess access = this.context.getLanguageAccess(_uRI_1);
            URI _uRI_2 = resource.getURI();
            final Set<URI> previous = newMappings.deleteSource(_uRI_2);
            JavaIoFileSystemAccess fileSystemAccess = this.getFileSystemAccess(access, request);
            fileSystemAccess.setCallBack(new JavaIoFileSystemAccess.IFileCallback(){

                public void fileAdded(File file) {
                    URI uri = FilesAndURIs.asURI(file);
                    URI _uRI = resource.getURI();
                    newMappings.addSource2Generated(_uRI, uri);
                    previous.remove(uri);
                    Procedures.Procedure2<? super URI, ? super URI> _afterGenerateFile = request.getAfterGenerateFile();
                    URI _uRI_1 = resource.getURI();
                    _afterGenerateFile.apply((Object)_uRI_1, (Object)uri);
                }

                public void fileDeleted(File file) {
                    URI uri = FilesAndURIs.asURI(file);
                    newMappings.deleteGenerated(uri);
                    Procedures.Procedure1<? super URI> _afterDeleteFile = request.getAfterDeleteFile();
                    _afterDeleteFile.apply((Object)uri);
                }
            });
            boolean _isWriteStorageResources = request.isWriteStorageResources();
            if (_isWriteStorageResources && !(_matched = false) && resource instanceof StorageAwareResource) {
                boolean _notEquals;
                IResourceStorageFacade _resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade();
                boolean bl = _notEquals = !Objects.equal((Object)_resourceStorageFacade, null);
                if (_notEquals) {
                    _matched = true;
                    IResourceStorageFacade _resourceStorageFacade_1 = ((StorageAwareResource)resource).getResourceStorageFacade();
                    _resourceStorageFacade_1.saveResource((StorageAwareResource)resource, (IFileSystemAccessExtension3)fileSystemAccess);
                }
            }
            IGenerator _generator = access.getGenerator();
            _generator.doGenerate(resource, (IFileSystemAccess)fileSystemAccess);
            Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                public void apply(URI it) {
                    LOG.info((Object)("Deleting stale generated file " + it));
                    File _asFile = FilesAndURIs.asFile(it);
                    _asFile.delete();
                    Procedures.Procedure1<? super URI> _afterDeleteFile = request.getAfterDeleteFile();
                    _afterDeleteFile.apply((Object)it);
                }
            };
            IterableExtensions.forEach(previous, (Procedures.Procedure1)_function);
        }

        protected JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language, BuildRequest request) {
            JavaIoFileSystemAccess fsa = this.configuredFsas.get(language);
            boolean _equals = Objects.equal((Object)fsa, null);
            if (_equals) {
                JavaIoFileSystemAccess _createFileSystemAccess;
                URI _baseDir = request.getBaseDir();
                File _asFile = FilesAndURIs.asFile(_baseDir);
                fsa = _createFileSystemAccess = language.createFileSystemAccess(_asFile);
                this.configuredFsas.put(language, fsa);
            }
            return fsa;
        }

        protected void setContext(BuildContext context) {
            this.context = context;
        }

        protected void setRequest(BuildRequest request) {
            this.request = request;
        }
    }
}

