/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BinaryFileHashing {
    private static final Logger LOG = Logger.getLogger(BinaryFileHashing.class);
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);

    public static void processDirectory(String directory, Map<IPath, HashCode> result, String fileExtension) {
        Files.fileTraverser().breadthFirst((Object)new File(directory)).forEach(file -> {
            if (file.isFile() && (fileExtension == null || file.getName().endsWith(fileExtension))) {
                BinaryFileHashing.processFile(file, result);
            }
        });
    }

    public static void processFile(File file, Map<IPath, HashCode> result) {
        Path path = new Path(file.getAbsolutePath());
        try {
            HashCode hash = Files.asByteSource((File)file).hash(HASH_FUNCTION);
            result.put((IPath)path, hash);
            LOG.trace((Object)("Hashed file " + path.lastSegment() + " to " + hash));
        }
        catch (IOException e) {
            result.put((IPath)path, BinaryFileHashing.unknownHashCode());
            LOG.warn((Object)("Failed to hash file " + path));
        }
    }

    public static HashFunction hashFunction() {
        return HASH_FUNCTION;
    }

    public static HashCode unknownHashCode() {
        return HashCode.fromInt((int)0);
    }
}

