/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.AbstractXtendMojo;
import org.eclipse.xtend.maven.MavenProjectResourceSetProvider;
import org.eclipse.xtend.maven.XtendMavenStandaloneSetup;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXtendCompilerMojo
extends AbstractXtendMojo {
    protected static final Predicate<String> FILE_EXISTS = new Predicate<String>(){

        public boolean apply(String filePath) {
            return new File(filePath).exists();
        }
    };
    private ToolchainManager toolchainManager;
    private MavenSession session;
    @Inject
    protected Provider<XtendBatchCompiler> xtendBatchCompilerProvider;
    protected String encoding;
    protected boolean writeTraceFiles;
    private String propertiesFileLocation;
    @Inject
    private RuntimeWorkspaceConfigProvider workspaceConfigProvider;

    protected XtendBatchCompiler createXtendBatchCompiler() {
        Injector injector = new XtendMavenStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtendBatchCompiler instance = (XtendBatchCompiler)injector.getInstance(XtendBatchCompiler.class);
        return instance;
    }

    protected void compile(XtendBatchCompiler xtend2BatchCompiler, String classPath, List<String> sourceDirectories, String outputPath) throws MojoExecutionException {
        this.configureWorkspace(sourceDirectories, outputPath);
        xtend2BatchCompiler.setResourceSetProvider((Provider)new MavenProjectResourceSetProvider(this.project));
        Iterable filtered = Iterables.filter(sourceDirectories, FILE_EXISTS);
        if (Iterables.isEmpty((Iterable)filtered)) {
            this.getLog().info((CharSequence)("skip compiling sources because the configured directory '" + Iterables.toString(sourceDirectories) + "' does not exists."));
            return;
        }
        this.getLog().debug((CharSequence)("Set temp directory: " + this.getTempDirectory()));
        xtend2BatchCompiler.setTempDirectory(this.getTempDirectory());
        this.getLog().debug((CharSequence)"Set DeleteTempDirectory: false");
        xtend2BatchCompiler.setDeleteTempDirectory(false);
        this.getLog().debug((CharSequence)("Set classpath: " + classPath));
        xtend2BatchCompiler.setClassPath(classPath);
        String bootClassPath = this.getBootClassPath();
        this.getLog().debug((CharSequence)("Set bootClasspath: " + bootClassPath));
        xtend2BatchCompiler.setBootClassPath(bootClassPath);
        this.getLog().debug((CharSequence)("Set source path: " + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered))));
        xtend2BatchCompiler.setSourcePath(Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)));
        this.getLog().debug((CharSequence)("Set output path: " + outputPath));
        xtend2BatchCompiler.setOutputPath(outputPath);
        this.getLog().debug((CharSequence)("Set encoding: " + this.encoding));
        xtend2BatchCompiler.setFileEncoding(this.encoding);
        this.getLog().debug((CharSequence)("Set writeTraceFiles: " + this.writeTraceFiles));
        xtend2BatchCompiler.setWriteTraceFiles(this.writeTraceFiles);
        if (!xtend2BatchCompiler.compile()) {
            throw new MojoExecutionException("Error compiling xtend sources in '" + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)) + "'.");
        }
    }

    private String getBootClassPath() {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain instanceof DefaultJavaToolChain) {
            Xpp3Dom bootClassPath;
            DefaultJavaToolChain javaToolChain = (DefaultJavaToolChain)toolchain;
            this.getLog().info((CharSequence)("Using toolchain " + javaToolChain));
            String[] includes = new String[]{"jre/lib/*", "jre/lib/ext/*", "jre/lib/endorsed/*"};
            String[] excludes = new String[]{};
            Xpp3Dom config = (Xpp3Dom)javaToolChain.getModel().getConfiguration();
            if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null) {
                Xpp3Dom excludeParent;
                Xpp3Dom includeParent = bootClassPath.getChild("includes");
                if (includeParent != null) {
                    includes = this.getValues(includeParent.getChildren("include"));
                }
                if ((excludeParent = bootClassPath.getChild("excludes")) != null) {
                    excludes = this.getValues(excludeParent.getChildren("exclude"));
                }
            }
            return this.scanBootclasspath(javaToolChain.getJavaHome(), includes, excludes);
        }
        return "";
    }

    private String scanBootclasspath(String javaHome, String[] includes, String[] excludes) {
        this.getLog().debug((CharSequence)("Scanning bootClassPath:\n\tjavaHome = " + javaHome + "\n" + "\tincludes = " + Arrays.toString(includes) + "\n" + "\texcludes = " + Arrays.toString(excludes)));
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(javaHome));
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        StringBuilder bootClassPath = new StringBuilder();
        String[] includedFiles = scanner.getIncludedFiles();
        int i = 0;
        while (i < includedFiles.length) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(new File(javaHome, includedFiles[i]).getAbsolutePath());
            ++i;
        }
        return bootClassPath.toString();
    }

    private String[] getValues(Xpp3Dom[] children) {
        String[] values = new String[children.length];
        int i = 0;
        while (i < values.length) {
            values[i] = children[i].getValue();
            ++i;
        }
        return values;
    }

    private void configureWorkspace(List<String> sourceDirectories, String outputPath) throws MojoExecutionException {
        WorkspaceConfig workspaceConfig = new WorkspaceConfig(this.project.getBasedir().getParentFile().getAbsolutePath());
        ProjectConfig projectConfig = new ProjectConfig(this.project.getBasedir().getName());
        URI absoluteRootPath = this.project.getBasedir().getAbsoluteFile().toURI();
        URI relativizedTarget = absoluteRootPath.relativize(new File(outputPath).toURI());
        if (relativizedTarget.isAbsolute()) {
            throw new MojoExecutionException("Output path '" + outputPath + "' must be a child of the project folder '" + absoluteRootPath + "'");
        }
        for (String string : sourceDirectories) {
            URI relativizedSrc = absoluteRootPath.relativize(new File(string).toURI());
            if (relativizedSrc.isAbsolute()) {
                throw new MojoExecutionException("Source folder " + string + " must be a child of the project folder " + absoluteRootPath);
            }
            projectConfig.addSourceFolderMapping(relativizedSrc.getPath(), relativizedTarget.getPath());
        }
        workspaceConfig.addProjectConfig(projectConfig);
        this.workspaceConfigProvider.setWorkspaceConfig(workspaceConfig);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("WS config root: " + workspaceConfig.getAbsoluteFileSystemPath()));
            this.getLog().debug((CharSequence)("Project name: " + projectConfig.getName()));
            this.getLog().debug((CharSequence)("Project root path: " + projectConfig.getRootPath()));
            for (Map.Entry entry : projectConfig.getSourceFolderMappings().entrySet()) {
                this.getLog().debug((CharSequence)("Source path: " + entry.getKey() + " -> " + entry.getValue()));
            }
        }
    }

    protected abstract String getTempDirectory();

    protected void addDependencies(Set<String> classPath, List<Artifact> dependencies) {
        for (Artifact artifact : dependencies) {
            classPath.add(artifact.getFile().getAbsolutePath());
        }
    }

    protected void readXtendEclipseSetting(String sourceDirectory, Procedures.Procedure1<String> fieldSetter) {
        block7: {
            if (this.propertiesFileLocation != null) {
                File f = new File(this.propertiesFileLocation);
                if (f.canRead()) {
                    Properties xtendSettings = new Properties();
                    try {
                        xtendSettings.load(new FileInputStream(f));
                        String xtendOutputDirProp = xtendSettings.getProperty("outlet.DEFAULT_OUTPUT.directory", null);
                        if (xtendOutputDirProp == null) break block7;
                        File srcDir = new File(sourceDirectory);
                        this.getLog().debug((CharSequence)("Source dir : " + srcDir.getPath() + " exists " + srcDir.exists()));
                        if (srcDir.exists() && srcDir.getParent() != null) {
                            String path = new File(srcDir.getParent(), xtendOutputDirProp).getPath();
                            this.getLog().debug((CharSequence)("Applying Xtend property: " + xtendOutputDirProp));
                            fieldSetter.apply((Object)path);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.getLog().warn((Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLog().warn((Throwable)e);
                    }
                } else {
                    this.getLog().info((CharSequence)("Can't find Xtend properties under " + this.propertiesFileLocation + ", maven defaults are used."));
                }
            }
        }
    }

    protected String resolveToBaseDir(String directory) throws MojoExecutionException {
        File outDir = new File(directory);
        if (!outDir.isAbsolute()) {
            outDir = new File(this.project.getBasedir(), directory);
        }
        return outDir.getAbsolutePath();
    }
}

