/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.maven.MavenProjectAdapter;
import org.eclipse.xtext.generator.trace.DefaultTraceURIConverter;
import org.eclipse.xtext.resource.XtextResource;

public class MavenTraceURIConverter
extends DefaultTraceURIConverter {
    public URI getURIForTrace(XtextResource context) {
        MavenProject project = MavenProjectAdapter.get(context.getResourceSet());
        URI uri = context.getURI();
        URI result = this.deresolve(project, uri);
        return result;
    }

    protected URI deresolve(MavenProject project, URI uri) {
        Iterable roots = Iterables.concat((Iterable)project.getCompileSourceRoots(), (Iterable)project.getTestCompileSourceRoots());
        for (String rootString : roots) {
            URI root;
            if (!rootString.endsWith("/")) {
                rootString = String.valueOf(rootString) + "/";
            }
            if (!this.isPrefix(root = URI.createFileURI((String)rootString), uri)) continue;
            return uri.deresolve(root);
        }
        throw new RuntimeException("Could not find source folder for '" + uri + "'. Folders:" + Lists.newArrayList((Iterable)roots));
    }
}

