/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.AbstractXtendMojo;
import org.eclipse.xtend.maven.MavenProjectResourceSetProvider;
import org.eclipse.xtend.maven.XtendMavenStandaloneSetup;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXtendCompilerMojo
extends AbstractXtendMojo {
    protected static final Predicate<String> FILE_EXISTS = new Predicate<String>(){

        public boolean apply(String filePath) {
            return new File(filePath).exists();
        }
    };
    @Inject
    protected Provider<XtendBatchCompiler> xtendBatchCompilerProvider;
    protected String encoding;
    protected boolean writeTraceFiles;
    private String propertiesFileLocation;

    protected XtendBatchCompiler createXtendBatchCompiler() {
        Injector injector = new XtendMavenStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtendBatchCompiler instance = (XtendBatchCompiler)injector.getInstance(XtendBatchCompiler.class);
        return instance;
    }

    protected void compile(XtendBatchCompiler xtend2BatchCompiler, String classPath, List<String> sourceDirectories, String outputPath) throws MojoExecutionException {
        xtend2BatchCompiler.setResourceSetProvider((Provider)new MavenProjectResourceSetProvider(this.project));
        Iterable filtered = Iterables.filter(sourceDirectories, FILE_EXISTS);
        if (Iterables.isEmpty((Iterable)filtered)) {
            this.getLog().info((CharSequence)("skip compiling sources because the configured directory '" + Iterables.toString(sourceDirectories) + "' does not exists."));
            return;
        }
        this.getLog().debug((CharSequence)("Set temp directory: " + this.getTempDirectory()));
        xtend2BatchCompiler.setTempDirectory(this.getTempDirectory());
        this.getLog().debug((CharSequence)"Set DeleteTempDirectory: false");
        xtend2BatchCompiler.setDeleteTempDirectory(false);
        this.getLog().debug((CharSequence)("Set classpath: " + classPath));
        xtend2BatchCompiler.setClassPath(classPath);
        this.getLog().debug((CharSequence)("Set source path: " + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered))));
        xtend2BatchCompiler.setSourcePath(Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)));
        this.getLog().debug((CharSequence)("Set output path: " + outputPath));
        xtend2BatchCompiler.setOutputPath(outputPath);
        this.getLog().debug((CharSequence)("Set encoding: " + this.encoding));
        xtend2BatchCompiler.setFileEncoding(this.encoding);
        this.getLog().debug((CharSequence)("Set writeTraceFiles: " + this.writeTraceFiles));
        xtend2BatchCompiler.setWriteTraceFiles(this.writeTraceFiles);
        if (!xtend2BatchCompiler.compile()) {
            throw new MojoExecutionException("Error compiling xtend sources in '" + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)) + "'.");
        }
    }

    protected abstract String getTempDirectory();

    protected void addDependencies(Set<String> classPath, List<Artifact> dependencies) {
        for (Artifact artifact : dependencies) {
            classPath.add(artifact.getFile().getAbsolutePath());
        }
    }

    protected void determinateOutputDirectory(String sourceDirectory, Procedures.Procedure1<String> fieldSetter) {
        block7: {
            if (this.propertiesFileLocation != null) {
                File f = new File(this.propertiesFileLocation);
                if (f.canRead()) {
                    Properties xtendSettings = new Properties();
                    try {
                        xtendSettings.load(new FileInputStream(f));
                        String xtendOutputDirProp = xtendSettings.getProperty("outlet.DEFAULT_OUTPUT.directory", null);
                        if (xtendOutputDirProp == null) break block7;
                        File srcDir = new File(sourceDirectory);
                        this.getLog().debug((CharSequence)("Source dir : " + srcDir.getPath() + " exists " + srcDir.exists()));
                        if (srcDir.exists() && srcDir.getParent() != null) {
                            String path = new File(srcDir.getParent(), xtendOutputDirProp).getPath();
                            this.getLog().debug((CharSequence)("Applying Xtend property: " + xtendOutputDirProp));
                            fieldSetter.apply((Object)path);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.getLog().warn((Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLog().warn((Throwable)e);
                    }
                } else {
                    this.getLog().info((CharSequence)("Can't load Xtend properties:" + this.propertiesFileLocation));
                }
            }
        }
    }
}

