/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtend.maven.AbstractXtendCompilerMojo;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XtendTestCompile
extends AbstractXtendCompilerMojo {
    private String testOutputDirectory;
    private String testTempDirectory;

    @Override
    protected void internalExecute() throws MojoExecutionException {
        String defaultValue = this.project.getBasedir() + "/src/test/generated-sources/xtend";
        this.getLog().debug((CharSequence)("Output directory '" + this.testOutputDirectory + "'"));
        this.getLog().debug((CharSequence)("Default directory '" + defaultValue + "'"));
        if (defaultValue.equals(this.testOutputDirectory)) {
            this.readXtendEclipseSetting(this.project.getBuild().getTestSourceDirectory(), new Procedures.Procedure1<String>(){

                public void apply(String xtendOutputDir) {
                    XtendTestCompile.this.testOutputDirectory = xtendOutputDir;
                    XtendTestCompile.this.getLog().info((CharSequence)("Using Xtend output directory '" + XtendTestCompile.this.testOutputDirectory + "'"));
                }
            });
        }
        this.testOutputDirectory = this.resolveToBaseDir(this.testOutputDirectory);
        ArrayList testCompileSourceRoots = Lists.newArrayList((Iterable)this.project.getTestCompileSourceRoots());
        testCompileSourceRoots.remove(this.testOutputDirectory);
        String testClassPath = Strings.concat((String)File.pathSeparator, this.getTestClassPath());
        this.project.addTestCompileSourceRoot(this.testOutputDirectory);
        this.compile(testClassPath, testCompileSourceRoots, this.testOutputDirectory);
    }

    protected List<String> getTestClassPath() {
        LinkedHashSet classPath = Sets.newLinkedHashSet();
        classPath.add(this.project.getBuild().getTestSourceDirectory());
        try {
            classPath.addAll(this.project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        this.addDependencies(classPath, this.project.getTestArtifacts());
        classPath.remove(this.project.getBuild().getTestOutputDirectory());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)classPath, (Predicate)FILE_EXISTS));
    }

    @Override
    protected String getTempDirectory() {
        return this.testTempDirectory;
    }
}

