/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.IReplacement;
import org.eclipse.xpect.text.Replacement;
import org.eclipse.xpect.text.Text;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.util.GrammarAnalyzer;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.XtextResource;

@XpectSetupFactory
public class XtextTargetSyntaxSupport
extends TargetSyntaxSupport {
    private final GrammarAnalyzer grammarAnalyzer;
    private final XtextResource resource;

    public XtextTargetSyntaxSupport(@ThisResource XtextResource resource) {
        this.resource = resource;
        this.grammarAnalyzer = new GrammarAnalyzer(((IGrammarAccess)resource.getResourceServiceProvider().get(IGrammarAccess.class)).getGrammar());
    }

    protected IReplacement convertToMultiLine(ILeafNode leaf, GrammarAnalyzer.SLCommentRule slRule, IReplacement replacement) {
        GrammarAnalyzer.MLCommentRule mlRule = this.getFirstMLCommentRule();
        if (mlRule != null) {
            String text = leaf.getText();
            int end = text.length();
            while (text.charAt(end - 1) == '\n' || text.charAt(end - 1) == '\r') {
                --end;
            }
            int offsetInLeaf = replacement.getOffset() - leaf.getOffset();
            StringBuilder newText = new StringBuilder();
            newText.append(mlRule.getStart());
            newText.append(text.substring(slRule.getStart().length(), offsetInLeaf));
            newText.append(replacement.getReplacement());
            int beginIndex = offsetInLeaf + replacement.getLength();
            if (beginIndex < end) {
                newText.append(text.substring(beginIndex, end));
            }
            newText.append(" ");
            newText.append(mlRule.getEnd());
            return new Replacement(replacement.getDocument(), leaf.getOffset(), end, newText.toString());
        }
        String document = leaf.getRootNode().getText();
        StringBuilder postIndentaiton = new StringBuilder();
        String text = leaf.getText();
        int i = slRule.getStart().length();
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            postIndentaiton.append(text.charAt(i++));
        }
        String indentation = new Text((CharSequence)document).findIndentation(leaf.getOffset());
        String oldIndentation = "\n" + indentation;
        String newIndentation = "\n" + indentation + slRule.getStart() + postIndentaiton;
        String newText = replacement.getReplacement().replace(oldIndentation, newIndentation);
        return new Replacement(replacement.getDocument(), replacement.getOffset(), replacement.getLength(), newText);
    }

    @Creates
    public TargetSyntaxSupport create() {
        return this;
    }

    protected IReplacement escapeTextInMultiLineComment(GrammarAnalyzer.MLCommentRule commentRule, IReplacement replacement) {
        String text = this.escapeTextInMultiLineComment(commentRule, replacement.getReplacement());
        return new Replacement(replacement.getDocument(), replacement.getOffset(), replacement.getLength(), text);
    }

    protected String escapeTextInMultiLineComment(GrammarAnalyzer.MLCommentRule commentRule, String replacement) {
        String escapedStart = this.getEscapeString(commentRule.getStart());
        String escapedEnd = this.getEscapeString(commentRule.getEnd());
        return replacement.replace(commentRule.getStart(), escapedStart).replace(commentRule.getEnd(), escapedEnd);
    }

    protected GrammarAnalyzer.CommentRule findCommentRule(ILeafNode leaf) {
        String text = leaf.getText();
        for (GrammarAnalyzer.CommentRule rule : this.grammarAnalyzer.getCommentRules()) {
            if (!text.startsWith(rule.getStart())) continue;
            return rule;
        }
        return null;
    }

    protected String getEscapeString(String startOrEnd) {
        if (startOrEnd.length() == 1) {
            return "_";
        }
        if (startOrEnd.length() > 1) {
            return String.valueOf(startOrEnd.charAt(0)) + "\\" + startOrEnd.substring(1);
        }
        return startOrEnd;
    }

    protected GrammarAnalyzer.MLCommentRule getFirstMLCommentRule() {
        for (GrammarAnalyzer.CommentRule rule : this.grammarAnalyzer.getCommentRules()) {
            if (!(rule instanceof GrammarAnalyzer.MLCommentRule)) continue;
            return (GrammarAnalyzer.MLCommentRule)rule;
        }
        return null;
    }

    public TargetSyntaxSupport.TargetLiteralSupport getLiteralSupport(int offset) {
        ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)this.resource.getParseResult().getRootNode(), (int)offset);
        GrammarAnalyzer.CommentRule commentRule = this.findCommentRule(leaf);
        return new XtextTargetSyntaxLiteral(leaf, commentRule);
    }

    public XtextResource getResource() {
        return this.resource;
    }

    public boolean supportsMultiLineLiteral() {
        return this.getFirstMLCommentRule() != null;
    }

    public int findFirstSemanticCharAfterStatement(XpectInvocation statement) {
        IStatementRelatedRegion region = statement.getExtendedRegion();
        int end = region.getOffset() + region.getLength();
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)this.resource.getParseResult().getRootNode(), (int)end);
        if (!node.isHidden()) {
            return node.getOffset();
        }
        NodeIterator it = new NodeIterator((INode)node);
        while (it.hasNext()) {
            INode next = it.next();
            if (!(next instanceof ILeafNode) || ((ILeafNode)next).isHidden()) continue;
            return next.getOffset();
        }
        throw new RuntimeException("Reached end of file while looking for semantic element for OFFSET");
    }

    public class XtextTargetSyntaxLiteral
    extends TargetSyntaxSupport.TargetLiteralSupport {
        private final GrammarAnalyzer.CommentRule commentRule;
        private final ILeafNode leaf;

        public XtextTargetSyntaxLiteral(ILeafNode leaf, GrammarAnalyzer.CommentRule commentRule) {
            this.leaf = leaf;
            this.commentRule = commentRule;
        }

        public IReplacement adoptToTargetSyntax(IReplacement replacement, boolean enforceMultilineLiteral) {
            if (this.leaf.getOffset() > replacement.getOffset()) {
                return replacement;
            }
            if (this.leaf.getOffset() + this.leaf.getLength() < replacement.getOffset() + replacement.getLength()) {
                return replacement;
            }
            if (this.commentRule instanceof GrammarAnalyzer.SLCommentRule) {
                if (enforceMultilineLiteral) {
                    return XtextTargetSyntaxSupport.this.convertToMultiLine(this.leaf, (GrammarAnalyzer.SLCommentRule)this.commentRule, replacement);
                }
            } else if (this.commentRule instanceof GrammarAnalyzer.MLCommentRule) {
                GrammarAnalyzer.MLCommentRule mlCommentRule = (GrammarAnalyzer.MLCommentRule)this.commentRule;
                if (replacement.getReplacement().contains(mlCommentRule.getEnd())) {
                    return XtextTargetSyntaxSupport.this.escapeTextInMultiLineComment(mlCommentRule, replacement);
                }
            }
            return replacement;
        }

        public String escape(String value) {
            if (this.commentRule instanceof GrammarAnalyzer.MLCommentRule) {
                return XtextTargetSyntaxSupport.this.escapeTextInMultiLineComment((GrammarAnalyzer.MLCommentRule)this.commentRule, value);
            }
            return value;
        }

        public boolean isMultiline() {
            return this.commentRule instanceof GrammarAnalyzer.MLCommentRule;
        }
    }
}

